/*
 * Decompiled with CFR 0.152.
 */
package com.cloudogu.scmmanager.scm;

import com.cloudogu.scmmanager.scm.api.ScmManagerHead;
import com.cloudogu.scmmanager.scm.api.ScmManagerPullRequestHead;
import com.cloudogu.scmmanager.scm.api.ScmManagerPullRequestRevision;
import com.cloudogu.scmmanager.scm.api.ScmManagerRevision;
import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Serializable;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;

public class LinkBuilder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String url;

    public LinkBuilder(String url) {
        this.url = url;
    }

    public LinkBuilder(String serverUrl, String namespace, String name) {
        this.url = this.concat(serverUrl, "repo", namespace, name);
    }

    @VisibleForTesting
    String concat(String base, String ... parts) {
        StringBuilder link = new StringBuilder(base);
        for (String part : parts) {
            if (!this.endsWith(link, '/') && !part.startsWith("/")) {
                link.append("/").append(part);
                continue;
            }
            if (this.endsWith(link, '/') && part.startsWith("/")) {
                link.append(part.substring(1));
                continue;
            }
            link.append(part);
        }
        return link.toString();
    }

    private boolean endsWith(CharSequence sequence, char c) {
        return sequence.charAt(sequence.length() - 1) == c;
    }

    public String repo() {
        return this.url;
    }

    public String create(@NonNull SCMHead head) {
        if (head instanceof ScmManagerPullRequestHead) {
            return this.concat(this.url, "pull-request", ((ScmManagerPullRequestHead)head).getId());
        }
        if (head instanceof ScmManagerHead) {
            return this.sources(head.getName());
        }
        throw new IllegalArgumentException("unknown type of head " + head);
    }

    public String create(@NonNull SCMRevision revision) {
        if (revision instanceof ScmManagerPullRequestRevision) {
            return this.sources(((ScmManagerPullRequestRevision)revision).getSourceRevision().getRevision());
        }
        if (revision instanceof ScmManagerRevision) {
            return this.sources(((ScmManagerRevision)revision).getRevision());
        }
        throw new IllegalArgumentException("unknown type of revision " + revision);
    }

    public String changeset(String revision) {
        return this.concat(this.url, "code/changeset", revision);
    }

    public String diff(String revision, String path) {
        return this.changeset(revision) + "#diff-" + path;
    }

    public String source(String revision, String path) {
        return this.concat(this.sources(revision), path);
    }

    private String sources(String revision) {
        return this.concat(this.url, "code/sources", revision);
    }
}

