/*
 * Decompiled with CFR 0.152.
 */
package com.cloudogu.scmmanager.scm;

import com.google.common.annotations.VisibleForTesting;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;

public final class Icons {
    private static final String URL_PATTERN = "plugin/scm-manager/images/%s/%s.png";

    private Icons() {
    }

    private static Icon icon(String name, Size size) {
        return new Icon(name + " " + size.className, String.format(URL_PATTERN, size.id, name), size.style);
    }

    public static void register(String name) {
        Icons.register(IconSet.icons, name);
    }

    @VisibleForTesting
    static void register(IconSet iconSet, String name) {
        for (Size size : Size.values()) {
            iconSet.addIcon(Icons.icon(name, size));
        }
    }

    public static enum Size {
        SMALL("16x16", "icon-sm", "width: 16px; height: 16px;"),
        MEDIUM("24x24", "icon-md", "width: 24px; height: 24px;"),
        LARGE("32x32", "icon-lg", "width: 32px; height: 32px;"),
        XLARGE("48x48", "icon-xlg", "width: 48px; height: 48px;");

        private final String id;
        private final String className;
        private final String style;

        private Size(String id, String className, String style) {
            this.id = id;
            this.className = className;
            this.style = style;
        }

        public String getId() {
            return this.id;
        }

        public String getClassName() {
            return this.className;
        }

        public String getStyle() {
            return this.style;
        }
    }
}

