/*
 * Decompiled with CFR 0.152.
 */
package com.cloudogu.scmmanager.scm;

import com.cloudogu.scmmanager.scm.api.Branch;
import com.cloudogu.scmmanager.scm.api.Repository;
import com.cloudogu.scmmanager.scm.api.ScmManagerApi;
import com.cloudogu.scmmanager.scm.api.ScmManagerHead;
import com.cloudogu.scmmanager.scm.api.ScmManagerPullRequestHead;
import com.cloudogu.scmmanager.scm.api.ScmManagerRevision;
import com.cloudogu.scmmanager.scm.api.ScmManagerTag;
import com.cloudogu.scmmanager.scm.api.Tag;
import java.util.concurrent.CompletableFuture;
import jenkins.scm.api.SCMHead;

public class HeadResolver {
    private final ScmManagerApi api;
    private final Repository repository;

    HeadResolver(ScmManagerApi api, Repository repository) {
        this.api = api;
        this.repository = repository;
    }

    CompletableFuture<ScmManagerRevision> resolve(SCMHead head) {
        if (head instanceof ScmManagerTag) {
            return this.api.getTag(this.repository, head.getName()).thenApply(Tag::revision);
        }
        if (head instanceof ScmManagerPullRequestHead) {
            String branch = ((ScmManagerPullRequestHead)head).getSource().getName();
            return this.api.getBranch(this.repository, branch).thenApply(Branch::revision);
        }
        if (head instanceof ScmManagerHead) {
            return this.api.getBranch(this.repository, head.getName()).thenApply(Branch::revision);
        }
        throw new IllegalArgumentException(head.getName() + " in not an instance of " + ScmManagerHead.class.getName());
    }
}

