/*
 * Decompiled with CFR 0.152.
 */
package com.cloudogu.scmmanager.info;

import com.cloudogu.scmmanager.info.JobInformation;
import com.cloudogu.scmmanager.info.ScmInformationResolver;
import com.google.common.base.Strings;
import hudson.Extension;
import hudson.model.Run;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.Revision;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.util.BuildData;
import hudson.scm.SCM;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@Extension(optional=true)
public class GitScmInformationResolver
implements ScmInformationResolver {
    private static final String TYPE = "git";

    @Override
    public Collection<JobInformation> resolve(Run<?, ?> run, SCM scm) {
        if (!(scm instanceof GitSCM)) {
            return Collections.emptyList();
        }
        GitSCM git = (GitSCM)scm;
        Optional<String> revision = this.getRevision(run, git);
        if (revision.isPresent()) {
            return this.createInformation(git, revision.get());
        }
        return Collections.emptyList();
    }

    private List<JobInformation> createInformation(GitSCM git, String revision) {
        ArrayList<JobInformation> information = new ArrayList<JobInformation>();
        for (UserRemoteConfig urc : git.getUserRemoteConfigs()) {
            information.add(this.createInformation(urc, revision));
        }
        return Collections.unmodifiableList(information);
    }

    private JobInformation createInformation(UserRemoteConfig urc, String revision) {
        return new JobInformation(TYPE, urc.getUrl(), revision, urc.getCredentialsId(), false);
    }

    private Optional<String> getRevision(Run<?, ?> run, GitSCM git) {
        String sha1;
        Revision rev;
        BuildData buildData = git.getBuildData(run);
        if (buildData != null && (rev = buildData.getLastBuiltRevision()) != null && !Strings.isNullOrEmpty((String)(sha1 = rev.getSha1String()))) {
            return Optional.of(sha1);
        }
        return Optional.empty();
    }
}

