/*
 * Decompiled with CFR 0.152.
 */
package com.cloudogu.scmmanager;

import com.cloudogu.scmmanager.BuildStatus;
import com.cloudogu.scmmanager.NamespaceAndName;
import com.cloudogu.scmmanager.Notifier;
import com.cloudogu.scmmanager.SSHAuthentication;
import com.cloudogu.scmmanager.SshConnectionFailedException;
import com.google.common.annotations.VisibleForTesting;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.Session;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.bind.JAXB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScmV2SshNotifier
implements Notifier {
    private static final Logger LOG = LoggerFactory.getLogger(ScmV2SshNotifier.class);
    private static final String SSH_COMMAND = "scm-ci-update --namespace %s --name %s --revision %s";
    private final NamespaceAndName namespaceAndName;
    private final Connection connection;
    private final SSHAuthentication authentication;

    ScmV2SshNotifier(NamespaceAndName namespaceAndName, Connection connection, SSHAuthentication authentication) {
        this.namespaceAndName = namespaceAndName;
        this.connection = connection;
        this.authentication = authentication;
    }

    @VisibleForTesting
    public NamespaceAndName getNamespaceAndName() {
        return this.namespaceAndName;
    }

    @VisibleForTesting
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void notify(String revision, BuildStatus buildStatus) throws IOException {
        LOG.info("set rev {} of {} to {}", new Object[]{revision, this.namespaceAndName, buildStatus.getStatus()});
        try {
            this.connect();
            this.executeStatusUpdateCommand(this.connection, revision, buildStatus);
        }
        finally {
            this.connection.close();
        }
    }

    private void connect() {
        try {
            this.connection.connect((s, i, s1, bytes) -> true);
            this.authentication.authenticate(this.connection);
        }
        catch (IOException ex) {
            throw new SshConnectionFailedException("ssh connection failed", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeStatusUpdateCommand(Connection connection, String revision, BuildStatus buildStatus) throws IOException {
        String cmd = String.format(SSH_COMMAND, this.namespaceAndName.getNamespace(), this.namespaceAndName.getName(), revision);
        try (Session session = null;){
            session = connection.openSession();
            session.execCommand(cmd);
            this.setBuildStatusTypeIfNull(buildStatus);
            this.marshalBuildStatusIntoOutputStream(session, buildStatus);
        }
    }

    private void setBuildStatusTypeIfNull(BuildStatus buildStatus) {
        if (buildStatus.getType() == null) {
            buildStatus.setType("jenkins");
        }
    }

    private void marshalBuildStatusIntoOutputStream(Session session, BuildStatus buildStatus) throws IOException {
        try (OutputStream out = session.getStdin();){
            JAXB.marshal((Object)buildStatus, (OutputStream)out);
            out.flush();
        }
    }
}

