/*
 * Decompiled with CFR 0.152.
 */
package com.cloudogu.scmmanager;

import com.cloudogu.scmmanager.BuildStatus;
import com.cloudogu.scmmanager.HttpAuthentication;
import com.cloudogu.scmmanager.NamespaceAndName;
import com.cloudogu.scmmanager.Notifier;
import com.google.common.annotations.VisibleForTesting;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Response;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import jenkins.plugins.asynchttpclient.AHC;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScmV2Notifier
implements Notifier {
    private static final Logger LOG = LoggerFactory.getLogger(ScmV2Notifier.class);
    private static final String CHANGESET_URL = "%s/api/v2/ci/%s/%s/changesets/%s/%s/%s";
    private static final String PULL_REQUEST_URL = "%s/api/v2/ci/%s/%s/pullrequest/%s/%s/%s";
    private final URL instance;
    private final NamespaceAndName namespaceAndName;
    private final HttpAuthentication httpAuthentication;
    private final boolean pullRequest;
    private AsyncHttpClient client;
    private Consumer<Response> completionListener = response -> {};

    ScmV2Notifier(URL instance, NamespaceAndName namespaceAndName, HttpAuthentication httpAuthentication, boolean pullRequest) {
        this.instance = instance;
        this.namespaceAndName = namespaceAndName;
        this.httpAuthentication = httpAuthentication;
        this.pullRequest = pullRequest;
    }

    @VisibleForTesting
    URL getInstance() {
        return this.instance;
    }

    @VisibleForTesting
    NamespaceAndName getNamespaceAndName() {
        return this.namespaceAndName;
    }

    @VisibleForTesting
    HttpAuthentication getHttpAuthentication() {
        return this.httpAuthentication;
    }

    @VisibleForTesting
    void setClient(AsyncHttpClient client) {
        this.client = client;
    }

    @VisibleForTesting
    void setCompletionListener(Consumer<Response> completionListener) {
        this.completionListener = completionListener;
    }

    private AsyncHttpClient getClient() {
        if (this.client == null) {
            return AHC.instance();
        }
        return this.client;
    }

    @Override
    public void notify(final String revision, BuildStatus buildStatus) throws IOException {
        LOG.info("set rev {} of {} to {}", new Object[]{revision, this.namespaceAndName, buildStatus.getStatus()});
        String url = this.createUrl(revision, buildStatus);
        LOG.info("send build status to {}", (Object)url);
        AsyncHttpClient.BoundRequestBuilder put = this.getClient().preparePut(url);
        this.httpAuthentication.authenticate(put);
        put.setHeader("Content-Type", "application/vnd.scmm-cistatus+json;v=2").setBody(this.createRequestBody(buildStatus)).execute((AsyncHandler)new AsyncCompletionHandler<Object>(){

            public void onThrowable(Throwable t) {
                LOG.warn("failed to notify scm-manager", t);
            }

            public Object onCompleted(Response response) {
                LOG.info("status notify for repository {} and revision {} returned {}", new Object[]{ScmV2Notifier.this.namespaceAndName, revision, response.getStatusCode()});
                ScmV2Notifier.this.completionListener.accept(response);
                return null;
            }
        });
    }

    private byte[] createRequestBody(BuildStatus buildStatus) {
        JSONObject jsonObject = JSONObject.fromObject((Object)buildStatus);
        return jsonObject.toString().getBytes(StandardCharsets.UTF_8);
    }

    private String createUrl(String revision, BuildStatus buildStatus) throws UnsupportedEncodingException {
        return String.format(this.getUrl(), this.instance.toExternalForm(), this.namespaceAndName.getNamespace(), this.namespaceAndName.getName(), revision, buildStatus.getType(), URLEncoder.encode(buildStatus.getName(), "UTF-8"));
    }

    private String getUrl() {
        return this.pullRequest ? PULL_REQUEST_URL : CHANGESET_URL;
    }
}

