/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.jtreg.parsers;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.plugins.report.jtreg.model.ReportFull;
import io.jenkins.plugins.report.jtreg.model.Suite;
import io.jenkins.plugins.report.jtreg.model.Test;
import io.jenkins.plugins.report.jtreg.model.TestOutput;
import io.jenkins.plugins.report.jtreg.model.TestStatus;
import io.jenkins.plugins.report.jtreg.parsers.ReportParser;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.tukaani.xz.XZInputStream;

public class JtregReportParser
implements ReportParser {
    private static final Map<String, ArchiveFactory> SUPPORTED_ARCHIVE_TYPES_MAP = JtregReportParser.createSupportedArchiveTypesMap();
    private static final String SYSTEMOUT = "system-out";
    private static final String SYSTEMERR = "system-err";
    private static final String TESTSUITE = "testsuite";
    private static final String TESTCASE = "testcase";
    private static final String PROPERTIES = "properties";
    private static final String FAILURE = "failure";
    private static final String SKIPPED = "skipped";
    private static final String ERROR = "error";

    @Override
    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION", "NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE", "RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification=" npe of spotbugs sucks")
    public Suite parsePath(Path path) {
        ArrayList<Test> testsList = new ArrayList<Test>();
        try (ArchiveInputStream in = this.streamPath(path);){
            ArchiveEntry entry;
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            while ((entry = in.getNextEntry()) != null) {
                String entryName = entry.getName();
                if (entryName == null || !entryName.endsWith(".jtr.xml")) continue;
                try {
                    XMLStreamReader reader = inputFactory.createXMLStreamReader((InputStream)new CloseShieldInputStream((InputStream)in), "UTF-8");
                    testsList.addAll(this.parseTestsuites(reader));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (testsList.isEmpty()) {
            return null;
        }
        List<String> testNames = ((Stream)testsList.stream().sequential()).map(t -> t.getName()).sorted().collect(Collectors.toList());
        List<Test> testProblems = ((Stream)testsList.stream().sequential()).filter(t -> t.getStatus() == TestStatus.ERROR || t.getStatus() == TestStatus.FAILED).sorted().collect(Collectors.toList());
        ReportFull fullReport = new ReportFull((int)((Stream)testsList.stream().sequential()).filter(t -> t.getStatus() == TestStatus.PASSED).count(), (int)((Stream)testsList.stream().sequential()).filter(t -> t.getStatus() == TestStatus.NOT_RUN).count(), (int)((Stream)testsList.stream().sequential()).filter(t -> t.getStatus() == TestStatus.FAILED).count(), (int)((Stream)testsList.stream().sequential()).filter(t -> t.getStatus() == TestStatus.ERROR).count(), testsList.size(), testProblems, testNames);
        return new Suite(this.suiteName(path), fullReport);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="We desrve to die")
    private String suiteName(Path path) {
        for (Map.Entry<String, ArchiveFactory> factory : SUPPORTED_ARCHIVE_TYPES_MAP.entrySet()) {
            String pathName = path.getFileName().toString();
            if (!pathName.toLowerCase().endsWith(factory.getKey())) continue;
            return pathName.substring(0, pathName.length() - factory.getKey().length());
        }
        return path.getFileName().toString();
    }

    private List<Test> parseTestsuites(XMLStreamReader in) throws Exception {
        ArrayList<Test> r = new ArrayList<Test>();
        String ignored = "com.google.security.wycheproof.OpenJDKAllTests";
        while (in.hasNext()) {
            int event = in.next();
            if (event != 1 || !TESTSUITE.equals(in.getLocalName())) continue;
            JtregBackwardCompatibileSuite suite = this.parseTestSuite(in);
            if (ignored.equals(suite.name)) {
                System.out.println("Skipping ignored suite : " + ignored);
                continue;
            }
            r.addAll(suite.getTests());
        }
        return r;
    }

    private String findAttributeValue(XMLStreamReader in, String name) {
        int count = in.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (!name.equals(in.getAttributeLocalName(i))) continue;
            return in.getAttributeValue(i);
        }
        return null;
    }

    private int tryParseString(String value) {
        if (value == null || value.trim().isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return 1;
        }
    }

    private String findStatusLine(XMLStreamReader in) throws Exception {
        int event;
        while (in.hasNext() && ((event = in.next()) != 2 || !PROPERTIES.equals(in.getLocalName()))) {
            if (event != 1 || !"property".equals(in.getLocalName()) || !"execStatus".equals(this.findAttributeValue(in, "name"))) continue;
            return this.findAttributeValue(in, "value");
        }
        return "";
    }

    private String captureCharacters(XMLStreamReader in, String element) throws Exception {
        int event;
        while (in.hasNext() && ((event = in.next()) != 2 || !element.equals(in.getLocalName()))) {
            if (event != 12 && event != 4) continue;
            StringBuilder outputString = new StringBuilder();
            do {
                outputString.append(in.getText());
            } while ((event = in.next()) == 12 || event == 4);
            return outputString.toString().trim();
        }
        return "";
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="We desrve to die")
    private ArchiveInputStream streamPath(Path path) throws IOException {
        for (Map.Entry<String, ArchiveFactory> factory : SUPPORTED_ARCHIVE_TYPES_MAP.entrySet()) {
            String pathName = path.getFileName().toString().toLowerCase();
            if (!pathName.endsWith(factory.getKey())) continue;
            BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
            return factory.getValue().create(stream);
        }
        throw new IOException("Unsupported archive format: " + path.getFileName());
    }

    private static Map<String, ArchiveFactory> createSupportedArchiveTypesMap() {
        HashMap<String, ArchiveFactory> map = new HashMap<String, ArchiveFactory>();
        map.put(".zip", in -> new ZipArchiveInputStream(in));
        map.put(".tar", in -> new TarArchiveInputStream(in));
        map.put(".tar.gz", in -> new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(in)));
        map.put(".tar.bz2", in -> new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream(in)));
        map.put(".tar.xz", in -> new TarArchiveInputStream((InputStream)new XZInputStream(in)));
        return Collections.unmodifiableMap(map);
    }

    private JtregBackwardCompatibileSuite parseTestSuite(XMLStreamReader in) throws XMLStreamException, Exception {
        String name = this.findAttributeValue(in, "name");
        String failuresStr = this.findAttributeValue(in, "failures");
        String errorsStr = this.findAttributeValue(in, "errors");
        String totalStr = this.findAttributeValue(in, "tests");
        String totalSkip = this.findAttributeValue(in, SKIPPED);
        int failures = this.tryParseString(failuresStr);
        int errors = this.tryParseString(errorsStr);
        int total = this.tryParseString(totalStr);
        int skipped = this.tryParseString(totalSkip);
        JtregBackwardCompatibileSuite suite = new JtregBackwardCompatibileSuite(name, failures, errors, total, skipped);
        String statusLine = "";
        String stdOutput = "";
        String errOutput = "";
        while (in.hasNext()) {
            int event = in.next();
            if (event == 1 && TESTCASE.equals(in.getLocalName())) {
                JtregBackwardCompatibileTest test = this.parseTestcase(in);
                suite.add(test);
                continue;
            }
            if (event == 1 && PROPERTIES.equals(in.getLocalName())) {
                statusLine = this.findStatusLine(in);
                continue;
            }
            if (event == 1 && SYSTEMOUT.equals(in.getLocalName())) {
                stdOutput = this.captureCharacters(in, SYSTEMOUT);
                continue;
            }
            if (event == 1 && SYSTEMERR.equals(in.getLocalName())) {
                errOutput = this.captureCharacters(in, SYSTEMERR);
                continue;
            }
            if (event != 2 || !TESTSUITE.equals(in.getLocalName())) continue;
            break;
        }
        List<TestOutput> outputs = Arrays.asList(new TestOutput(SYSTEMOUT, stdOutput), new TestOutput(SYSTEMERR, errOutput));
        suite.setStatusLine(statusLine);
        suite.setOutputs(outputs);
        return suite;
    }

    private JtregBackwardCompatibileTest parseTestcase(XMLStreamReader in) throws Exception {
        String testName = this.findAttributeValue(in, "name");
        String className = this.findAttributeValue(in, "classname");
        TestStatus status = TestStatus.PASSED;
        String failureOutput = "";
        String stdOutput = "";
        String sysErrOutput = "";
        String message = "";
        StringBuilder errOutput = new StringBuilder();
        while (in.hasNext()) {
            int event = in.next();
            if (event == 1 && FAILURE.equals(in.getLocalName())) {
                String lEmessage = this.findAttributeValue(in, "message");
                if (lEmessage != null) {
                    message = lEmessage;
                }
                failureOutput = this.captureCharacters(in, FAILURE);
                if (status == TestStatus.ERROR) continue;
                status = TestStatus.FAILED;
                continue;
            }
            if (event == 1 && SYSTEMOUT.equals(in.getLocalName())) {
                stdOutput = this.captureCharacters(in, SYSTEMOUT);
                continue;
            }
            if (event == 1 && SYSTEMERR.equals(in.getLocalName())) {
                sysErrOutput = this.captureCharacters(in, SYSTEMERR);
                continue;
            }
            if (event == 1 && SKIPPED.equals(in.getLocalName())) {
                status = TestStatus.NOT_RUN;
                continue;
            }
            if (event == 1 && ERROR.equals(in.getLocalName())) {
                status = TestStatus.ERROR;
                errOutput.append(this.captureCharacters(in, ERROR)).append('\n');
                continue;
            }
            if (event != 2 || !TESTCASE.equals(in.getLocalName())) continue;
            break;
        }
        List<TestOutput> outputs = Arrays.asList(new TestOutput(SYSTEMOUT, stdOutput), new TestOutput(SYSTEMERR, sysErrOutput));
        return new JtregBackwardCompatibileTest(className, status, message, outputs, testName, failureOutput, errOutput.toString());
    }

    private static class JtregBackwardCompatibileSuite {
        private final String name;
        private final int failures;
        private final int errors;
        private final int total;
        private final int skipped;
        private List<TestOutput> outputs;
        private final List<JtregBackwardCompatibileTest> settedTests = new ArrayList<JtregBackwardCompatibileTest>();
        private List<Test> revalidatedCopyOfTests;
        private String statusLine;
        private boolean validated = false;

        private void revalidateTests() {
            this.revalidatedCopyOfTests = new ArrayList<Test>(this.settedTests.size());
            int cPass = 0;
            int cFail = 0;
            int cErr = 0;
            int cSkipp = 0;
            int cTotoal = 0;
            for (JtregBackwardCompatibileTest testcase : this.settedTests) {
                Test t = this.mergeOutputs(this.name + "#" + testcase.testName, testcase, testcase.getStatus());
                switch (t.getStatus()) {
                    case ERROR: {
                        ++cErr;
                        break;
                    }
                    case FAILED: {
                        ++cFail;
                        break;
                    }
                    case NOT_RUN: {
                        ++cSkipp;
                        break;
                    }
                    case PASSED: {
                        ++cPass;
                    }
                }
                ++cTotoal;
                this.revalidatedCopyOfTests.add(t);
            }
            int i = 0;
            System.out.println("Control summs '" + this.name + "'(skipped " + cSkipp + "):");
            if (cTotoal != this.total) {
                System.out.println("Total tests expected " + this.total + " got " + cTotoal);
                ++i;
            }
            if (cFail != this.failures) {
                System.out.println("Failed tests expected " + this.failures + " got " + cFail);
                ++i;
            }
            if (cErr != this.errors) {
                System.out.println("Error tests expected " + this.errors + " got " + cErr);
                ++i;
            }
            if (cSkipp != this.skipped) {
                System.out.println("Skipped tests expected " + this.skipped + " got " + cSkipp);
                ++i;
            }
            if (cErr + cFail + cPass + cSkipp != cTotoal) {
                System.out.println("Total(2) tests expected " + cTotoal + " got " + (cErr + cFail + cPass + cSkipp));
                ++i;
            }
            if (i == 0) {
                System.out.println("Pass");
            }
            this.validated = true;
        }

        private JtregBackwardCompatibileSuite(String name, int failures, int errors, int totals, int skipped) {
            this.name = name;
            this.failures = failures;
            this.errors = errors;
            this.total = totals;
            this.skipped = skipped;
        }

        private Collection<? extends Test> getTests() {
            if (!this.validated) {
                this.revalidateTests();
            }
            return this.revalidatedCopyOfTests;
        }

        private void setStatusLine(String statusLine) {
            this.statusLine = statusLine;
        }

        private void setOutputs(List<TestOutput> outputs) {
            this.outputs = outputs;
        }

        private void add(JtregBackwardCompatibileTest test) {
            this.validated = false;
            this.settedTests.add(test);
        }

        private Test mergeOutputs(String nwName, JtregBackwardCompatibileTest testcase, TestStatus st) {
            Object nwStatus;
            List<TestOutput> newOutputs = Arrays.asList(new TestOutput(JtregReportParser.SYSTEMOUT, "---- suite ----\n" + this.outputs.get(0).getValue() + "\n---- test ----\n" + testcase.getOutputs().get(0).getValue()), new TestOutput(JtregReportParser.SYSTEMERR, "---- suite ----\n" + this.outputs.get(1).getValue() + "\n---- test ----\n" + testcase.getOutputs().get(1).getValue() + "\n---- fail ----\n" + testcase.failureOutput + "\n---- error ----\n" + testcase.errorOutput));
            if (this.statusLine.equals(testcase.getStatusLine())) {
                nwStatus = this.statusLine;
            } else {
                String del = "";
                if (this.statusLine.trim().length() > 0 && testcase.getStatusLine().trim().length() > 0) {
                    del = " ; ";
                }
                nwStatus = this.statusLine + del + testcase.getStatusLine();
            }
            return new Test(nwName, st, (String)nwStatus, newOutputs);
        }
    }

    @SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"}, justification="The Test ishandlig classes properly,but yes, this may get broken any time")
    private static class JtregBackwardCompatibileTest
    extends Test {
        private final String testName;
        private final String failureOutput;
        private final String errorOutput;

        public JtregBackwardCompatibileTest(String className, TestStatus status, String statusLine, List<TestOutput> outputs, String testName, String failureOutput, String errorOutput) {
            super(className, status, statusLine, outputs);
            this.testName = testName;
            this.failureOutput = failureOutput;
            this.errorOutput = errorOutput;
        }
    }

    @FunctionalInterface
    private static interface ArchiveFactory {
        public ArchiveInputStream create(InputStream var1) throws IOException;
    }
}

