/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.jtreg.parsers;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.plugins.report.jtreg.model.ReportFull;
import io.jenkins.plugins.report.jtreg.model.Suite;
import io.jenkins.plugins.report.jtreg.model.Test;
import io.jenkins.plugins.report.jtreg.model.TestOutput;
import io.jenkins.plugins.report.jtreg.model.TestStatus;
import io.jenkins.plugins.report.jtreg.parsers.ReportParser;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.tukaani.xz.XZInputStream;

public class JckReportParser
implements ReportParser {
    @Override
    public Suite parsePath(Path path) {
        Suite suite;
        block8: {
            InputStream in = this.streamPath(path);
            try {
                ReportFull report = this.parseReport(in);
                suite = new Suite(this.suiteName(path), report);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            in.close();
        }
        return suite;
    }

    private InputStream streamPath(Path path) throws IOException {
        BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
        if (path.toString().endsWith(".gz")) {
            return new GZIPInputStream(stream);
        }
        if (path.toString().endsWith(".xz")) {
            return new XZInputStream((InputStream)stream);
        }
        return stream;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="We desrve to die")
    private String suiteName(Path path) {
        String fullName = path.getFileName().toString();
        if (fullName.endsWith(".xml.xz")) {
            return fullName.substring(0, fullName.length() - 7);
        }
        if (fullName.endsWith(".xml.gz")) {
            return fullName.substring(0, fullName.length() - 7);
        }
        if (fullName.endsWith(".xml")) {
            return fullName.substring(0, fullName.length() - 4);
        }
        throw new IllegalArgumentException("file name does not end with either .xml or .xml.gz extension: " + fullName);
    }

    ReportFull parseReport(InputStream reportStream) throws Exception {
        try (InputStreamReader reader = new InputStreamReader(reportStream, "UTF-8");){
            ReportFull report;
            ReportFull reportFull = report = this.parseReport(reader);
            return reportFull;
        }
    }

    private ReportFull parseReport(Reader reader) throws Exception {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("http://java.sun.com/xml/stream/properties/report-cdata-event", Boolean.TRUE);
        factory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        XMLStreamReader in = factory.createXMLStreamReader(reader);
        if (!this.fastForwardToElement(in, "TestResults")) {
            throw new Exception("TestResults element was not found in provided XML stream");
        }
        return this.processTestResults(in);
    }

    private boolean fastForwardToElement(XMLStreamReader reader, String element) throws Exception {
        while (reader.hasNext()) {
            if (reader.next() != 1 || !element.equals(reader.getLocalName())) continue;
            return true;
        }
        return false;
    }

    private ReportFull processTestResults(XMLStreamReader in) throws Exception {
        int event;
        Map<String, AtomicInteger> countersMap = this.createCountersMap();
        ArrayList<Test> testProblemsList = new ArrayList<Test>();
        ArrayList<String> fullTestsList = new ArrayList<String>();
        while (in.hasNext() && ((event = in.next()) != 2 || !"TestResults".equals(in.getLocalName()))) {
            if (event != 1 || !"TestResult".equals(in.getLocalName())) continue;
            String testStatus = this.findAttributeValue(in, "status");
            this.incrementCounters(testStatus, countersMap);
            Test test = this.parseTest(in);
            if (test.getStatus() != TestStatus.NOT_RUN) {
                fullTestsList.add(test.getName());
            }
            if (!this.isProblematic(testStatus)) continue;
            testProblemsList.add(test);
        }
        Collections.sort(testProblemsList);
        Collections.sort(fullTestsList);
        return new ReportFull(countersMap.get("PASSED").get(), countersMap.get("NOT_RUN").get(), countersMap.get("FAILED").get(), countersMap.get("ERROR").get(), countersMap.get("TOTAL").get(), testProblemsList, fullTestsList);
    }

    private Test parseTest(XMLStreamReader in) throws Exception {
        int event;
        String url = this.findAttributeValue(in, "url");
        String status = this.findAttributeValue(in, "status");
        List<TestOutput> testOutputs = Collections.emptyList();
        String statusLine = null;
        while (in.hasNext() && ((event = in.next()) != 2 || !"TestResult".equals(in.getLocalName()))) {
            if (event != 1) continue;
            if ("ResultProperties".equals(in.getLocalName())) {
                statusLine = this.processStatusLine(in);
            }
            if (!"Sections".equals(in.getLocalName())) continue;
            testOutputs = this.processTestOutputs(in);
        }
        return new Test(url, TestStatus.valueOf(status.toUpperCase()), statusLine, testOutputs);
    }

    private String processStatusLine(XMLStreamReader in) throws Exception {
        int event;
        String line = "";
        while (in.hasNext() && ((event = in.next()) != 2 || !"ResultProperties".equals(in.getLocalName()))) {
            if (event != 1 || !"Property".equals(in.getLocalName()) || !"execStatus".equals(this.findAttributeValue(in, "name"))) continue;
            line = this.findAttributeValue(in, "value");
        }
        return line;
    }

    private List<TestOutput> processTestOutputs(XMLStreamReader in) throws Exception {
        int event;
        ArrayList<TestOutput> list = new ArrayList<TestOutput>();
        while (in.hasNext() && ((event = in.next()) != 2 || !"Sections".equals(in.getLocalName()))) {
            if (event != 1 || !"Section".equals(in.getLocalName())) continue;
            list.addAll(this.processOutputSection(in));
        }
        Collections.sort(list);
        return list;
    }

    private List<TestOutput> processOutputSection(XMLStreamReader in) throws Exception {
        int event;
        String title = this.findAttributeValue(in, "title");
        ArrayList<TestOutput> list = new ArrayList<TestOutput>();
        while (in.hasNext() && ((event = in.next()) != 2 || !"Section".equals(in.getLocalName()))) {
            if (event != 1 || !"Output".equals(in.getLocalName())) continue;
            list.add(this.processTestOutput(title, in));
        }
        return list;
    }

    private TestOutput processTestOutput(String sectionTitle, XMLStreamReader in) throws Exception {
        int event;
        String title = this.findAttributeValue(in, "title");
        String resultTitle = sectionTitle + " / " + title;
        while (in.hasNext() && ((event = in.next()) != 2 || !"Output".equals(in.getLocalName()))) {
            if (event != 12 && event != 4) continue;
            StringBuilder outputString = new StringBuilder();
            do {
                outputString.append(in.getText());
            } while ((event = in.next()) == 12 || event == 4);
            return new TestOutput(resultTitle, outputString.toString().trim());
        }
        return new TestOutput(resultTitle, "");
    }

    private void incrementCounters(String testStatus, Map<String, AtomicInteger> countersMap) throws Exception {
        AtomicInteger aInt = countersMap.get(testStatus);
        if (aInt == null) {
            throw new Exception("Invalid 'status' attribute value: " + testStatus);
        }
        aInt.incrementAndGet();
        countersMap.get("TOTAL").incrementAndGet();
    }

    private boolean isProblematic(String testStatus) {
        switch (testStatus) {
            case "FAILED": 
            case "ERROR": {
                return true;
            }
        }
        return false;
    }

    private String findAttributeValue(XMLStreamReader in, String name) {
        int count = in.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (!name.equals(in.getAttributeLocalName(i))) continue;
            return in.getAttributeValue(i);
        }
        return null;
    }

    private Map<String, AtomicInteger> createCountersMap() {
        HashMap<String, AtomicInteger> map = new HashMap<String, AtomicInteger>();
        map.put("NOT_RUN", new AtomicInteger());
        map.put("PASSED", new AtomicInteger());
        map.put("FAILED", new AtomicInteger());
        map.put("ERROR", new AtomicInteger());
        map.put("TOTAL", new AtomicInteger());
        return map;
    }
}

