/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.jtreg.model;

import io.jenkins.plugins.report.jtreg.model.TestOutput;
import io.jenkins.plugins.report.jtreg.model.TestStatus;
import io.jenkins.plugins.report.jtreg.utils.MoreStrings;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class Test
implements Comparable<Test>,
Serializable {
    private final String name;
    private final TestStatus status;
    private final String statusLine;
    private final List<TestOutput> outputs;

    public Test(String name, TestStatus status, String statusLine, List<TestOutput> outputs) {
        this.name = name;
        this.status = status;
        this.statusLine = statusLine;
        this.outputs = outputs;
    }

    public String getName() {
        return this.name;
    }

    public TestStatus getStatus() {
        return this.status;
    }

    public String getStatusLine() {
        return this.statusLine;
    }

    public List<TestOutput> getOutputs() {
        return this.outputs;
    }

    @Override
    public int compareTo(Test o) {
        return MoreStrings.compareStrings(this.name, o.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Test test = (Test)o;
        return Objects.equals(this.name, test.name) && this.status == test.status && Objects.equals(this.statusLine, test.statusLine) && Objects.equals(this.outputs, test.outputs);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.status, this.statusLine, this.outputs});
    }

    public String toString() {
        return "Test{name='" + this.name + "', status=" + this.status + ", statusLine='" + this.statusLine + "', outputs=" + this.outputs + "}";
    }

    public String getTrackingUrl(String job) {
        return "no url for lib";
    }
}

