/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.jtreg.model;

import io.jenkins.plugins.report.jtreg.model.BuildReport;
import io.jenkins.plugins.report.jtreg.model.Suite;
import io.jenkins.plugins.report.jtreg.model.SuiteTests;
import io.jenkins.plugins.report.jtreg.model.SuiteTestsWithResults;
import io.jenkins.plugins.report.jtreg.model.Test;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SuitesWithResults
implements Serializable {
    private final List<SuiteTestsWithResults> suitests;

    public static SuitesWithResults create(List<SuiteTests> currentBuildTestsList, BuildReport problems, String job, int id) {
        ArrayList<SuiteTestsWithResults> futureSuitests = new ArrayList<SuiteTestsWithResults>(currentBuildTestsList.size());
        for (SuiteTests suiteTest : currentBuildTestsList) {
            ArrayList<SuiteTestsWithResults.StringWithResult> testsForThisSuite = new ArrayList<SuiteTestsWithResults.StringWithResult>(suiteTest.getTests().size());
            for (String test : suiteTest.getTests()) {
                if (SuitesWithResults.isProblem(suiteTest.getName(), test, problems.getSuites())) {
                    testsForThisSuite.add(new SuiteTestsWithResults.StringWithResult(test, SuiteTestsWithResults.TestStatusSimplified.FAILED_OR_ERROR));
                    continue;
                }
                testsForThisSuite.add(new SuiteTestsWithResults.StringWithResult(test, SuiteTestsWithResults.TestStatusSimplified.PASSED_OR_MISSING));
            }
            futureSuitests.add(new SuiteTestsWithResults(suiteTest.getName(), testsForThisSuite, job, id));
        }
        return new SuitesWithResults(futureSuitests);
    }

    private static boolean isProblem(String suiteName, String test, List<Suite> probelms) {
        for (Suite probelm : probelms) {
            if (!probelm.getName().equals(suiteName)) continue;
            for (Test t : probelm.getReport().getTestProblems()) {
                if (!t.getName().equals(test)) continue;
                return true;
            }
        }
        return false;
    }

    public SuitesWithResults(List<SuiteTestsWithResults> suitests) {
        this.suitests = suitests;
    }

    public List<SuiteTestsWithResults> getAllTestsAndSuites() {
        return Collections.unmodifiableList(this.suitests);
    }
}

