/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.jtreg.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SuiteTestsWithResults
implements Serializable {
    private static final int MAX = 1000;
    private final String name;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="should be internal implementation only, and thus ArrayList and that is serialisable")
    private final List<StringWithResult> tests;
    private final String job;
    private final int id;

    public SuiteTestsWithResults(String name, List<StringWithResult> tests, String job, int id) {
        this.name = name;
        this.tests = tests;
        this.job = job;
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public List<StringWithResult> getTests() {
        return Collections.unmodifiableList(this.tests);
    }

    public List<StringWithResult> getTestsLimited() {
        if (this.tests.size() <= 1000) {
            return this.getTests();
        }
        ArrayList<StringWithResult> truncated = new ArrayList<StringWithResult>(1001);
        for (int i = 0; i < 1000; ++i) {
            StringWithResult get = this.tests.get(i);
            truncated.add(get);
        }
        return truncated;
    }

    public String getSentence() {
        if (this.tests == null || this.tests.isEmpty()) {
            return "... No tests at all. Feel free to use our cmdline diff tool or ";
        }
        if (this.tests.size() <= 1000) {
            return "... Shown all " + this.tests.size() + " tests. Feel free to use our cmdline diff tool or ";
        }
        return "... Shown 1000 from " + this.tests.size() + " tests. To see remaining " + (this.tests.size() - 1000) + " use our cmdline diff tool or ";
    }

    public static enum TestStatusSimplified {
        PASSED_OR_MISSING,
        FAILED_OR_ERROR;


        public boolean isFailed() {
            return this == FAILED_OR_ERROR;
        }

        public boolean isPassed() {
            return this == PASSED_OR_MISSING;
        }

        public String toString() {
            switch (this) {
                case PASSED_OR_MISSING: {
                    return "(PASS or MISSING)";
                }
                case FAILED_OR_ERROR: {
                    return "(FAILED or ERROR)";
                }
            }
            throw new RuntimeException("Unknown enum member");
        }
    }

    public static class StringWithResult {
        private final String testName;
        private final TestStatusSimplified status;

        public StringWithResult(String testName, TestStatusSimplified status) {
            this.testName = testName;
            this.status = status;
        }

        public TestStatusSimplified getStatus() {
            return this.status;
        }

        public String getTestName() {
            return this.testName;
        }
    }
}

