/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.jtreg.model;

import io.jenkins.plugins.report.jtreg.model.Report;
import io.jenkins.plugins.report.jtreg.utils.MoreStrings;
import java.io.Serializable;
import java.util.Objects;

public class Suite
implements Comparable<Suite>,
Serializable {
    private final String name;
    private final Report report;

    public Suite(String name, Report report) {
        this.name = name;
        this.report = report;
    }

    public String getName() {
        return this.name;
    }

    public Report getReport() {
        return this.report;
    }

    @Override
    public int compareTo(Suite o) {
        return MoreStrings.compareStrings(this.name, o.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Suite suite = (Suite)o;
        return Objects.equals(this.name, suite.name) && Objects.equals(this.report, suite.report);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.report);
    }

    public String toString() {
        return "Suite{name='" + this.name + "', report=" + this.report + "}";
    }
}

