/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.jtreg.model;

import io.jenkins.plugins.report.jtreg.model.Test;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class Report
implements Serializable {
    private final int testsPassed;
    private final int testsNotRun;
    private final int testsFailed;
    private final int testsError;
    private final int testsTotal;
    private final List<Test> testProblems;

    public Report(int testsPassed, int testsNotRun, int testsFailed, int testsError, int testsTotal, List<Test> testProblems) {
        this.testsPassed = testsPassed;
        this.testsNotRun = testsNotRun;
        this.testsFailed = testsFailed;
        this.testsError = testsError;
        this.testsTotal = testsTotal;
        this.testProblems = testProblems;
    }

    public int getTestsPassed() {
        return this.testsPassed;
    }

    public int getTestsNotRun() {
        return this.testsNotRun;
    }

    public int getTestsFailed() {
        return this.testsFailed;
    }

    public int getTestsError() {
        return this.testsError;
    }

    public int getTestsTotal() {
        return this.testsTotal;
    }

    public List<Test> getTestProblems() {
        return this.testProblems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Report report = (Report)o;
        return this.testsPassed == report.testsPassed && this.testsNotRun == report.testsNotRun && this.testsFailed == report.testsFailed && this.testsError == report.testsError && this.testsTotal == report.testsTotal && Objects.equals(this.testProblems, report.testProblems);
    }

    public int hashCode() {
        return Objects.hash(this.testsPassed, this.testsNotRun, this.testsFailed, this.testsError, this.testsTotal, this.testProblems);
    }

    public String toString() {
        return "Report{testsPassed=" + this.testsPassed + ", testsNotRun=" + this.testsNotRun + ", testsFailed=" + this.testsFailed + ", testsError=" + this.testsError + ", testsTotal=" + this.testsTotal + ", testProblems=" + this.testProblems + "}";
    }
}

