/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.jtreg.model;

import io.jenkins.plugins.report.jtreg.model.Suite;
import java.io.Serializable;
import java.util.List;

public class BuildReport
implements Serializable {
    private final int buildNumber;
    private final String buildName;
    private final int passed;
    private final int failed;
    private final int error;
    private final int total;
    private final int notRun;
    private final int run;
    private final List<Suite> suites;

    public BuildReport(int buildNumber, String buildName, int passed, int failed, int error, List<Suite> suites, int total, int notRun) {
        this.buildNumber = buildNumber;
        this.buildName = buildName;
        this.passed = passed;
        this.failed = failed;
        this.error = error;
        this.suites = suites;
        this.total = total;
        this.notRun = notRun;
        this.run = 0;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public String getBuildName() {
        return this.buildName;
    }

    public int getPassed() {
        return this.passed;
    }

    public int getFailed() {
        return this.failed;
    }

    public int getError() {
        return this.error;
    }

    public List<Suite> getSuites() {
        return this.suites;
    }

    public int getTotal() {
        return this.total;
    }

    public int getNotRun() {
        return this.notRun;
    }

    public int getRun() {
        return this.total - this.notRun;
    }

    public boolean isInvalid() {
        return this.passed == 0 && this.failed == 0 && this.error == 0 && this.total == 0 && this.notRun == 0 && this.run == 0;
    }
}

