/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.jtreg.main.diff.cmdline;

import io.jenkins.plugins.report.jtreg.formatters.Formatter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;

public class JobsRecognition {
    private static JobsRecognition INSTANCE;
    private static final Map<File, String> cache;
    private String jenkinsDir;
    private File jobsDir;
    private static final Map<File, String> nvrCache;
    private final Pattern ABRTD = Pattern.compile(".*ABORTED.*");
    private final Pattern FAILD = Pattern.compile(".*FAILURE.*");
    private final Pattern UNSTB = Pattern.compile(".*UNSTABLE.*");
    private final Pattern PASSD = Pattern.compile(".*SUCCESS.*");

    public static JobsRecognition jobsRecognition() {
        if (INSTANCE == null) {
            INSTANCE = new JobsRecognition();
        }
        return INSTANCE;
    }

    public JobsRecognition() {
        this.jenkinsDir = System.getProperty("jenkins_home");
        if (this.jenkinsDir == null) {
            this.jenkinsDir = System.getenv("JENKINS_HOME");
        }
        this.jobsDir = new File(this.jenkinsDir, "jobs");
    }

    public File getJobsDir() {
        return this.jobsDir;
    }

    public String getJenkinsDir() {
        return this.jenkinsDir;
    }

    public static String[] getNonNullListing(File f) {
        String[] l = f.list();
        if (l == null) {
            throw new NullPointerException(f + " do not exists or is file or not accessible or hidden io error occured");
        }
        return l;
    }

    public String[] getPossibleJobs() {
        String[] possibleJobs = JobsRecognition.getNonNullListing(this.jobsDir);
        Arrays.sort(possibleJobs, Collections.reverseOrder());
        return possibleJobs;
    }

    public boolean isJob(String jobName) {
        return JobsRecognition.arrayContains(this.getPossibleJobs(), jobName);
    }

    private File creteJobFile(String jobName) {
        return new File(this.jobsDir, jobName);
    }

    private File creteBuildsDir(String jobName) {
        return new File(this.creteJobFile(jobName), "builds");
    }

    public File creteBuildDir(String jobName, int id) {
        return new File(this.creteBuildsDir(jobName), String.valueOf(id));
    }

    private File creteLogFile(String jobName, int id) {
        return JobsRecognition.creteLogFile(this.creteBuildDir(jobName, id));
    }

    private static File creteLogFile(File dir) {
        return new File(dir, "log");
    }

    public File creteChangelogFile(String jobName, int id) {
        return JobsRecognition.creteChangelogFile(this.creteBuildDir(jobName, id));
    }

    public static File creteChangelogFile(File dir) {
        return new File(dir, "changelog.xml");
    }

    public static boolean arrayContains(String[] as, String s) {
        for (String a : as) {
            if (!a.equals(s)) continue;
            return true;
        }
        return false;
    }

    public int getLatestBuildId(String jobName) {
        return JobsRecognition.getLatestBuildId(this.creteBuildsDir(jobName));
    }

    private static int getLatestBuildId(File jobDir) {
        if (jobDir.exists() && jobDir.isDirectory()) {
            String[] files = JobsRecognition.getNonNullListing(jobDir);
            ArrayList<Integer> results = new ArrayList<Integer>(files.length);
            for (String file : files) {
                try {
                    Integer i = Integer.valueOf(file);
                    results.add(i);
                }
                catch (Exception ex) {
                    System.err.println(jobDir + "/" + file + " is not number.");
                }
            }
            Collections.sort(results);
            return (Integer)results.get(results.size() - 1);
        }
        throw new RuntimeException(jobDir + " do not exists or is not directory");
    }

    public void checkJob(String jobName) {
        if (!this.isJob(jobName)) {
            String[] pj;
            System.err.println("Possible jobs");
            for (String jobs : pj = this.getPossibleJobs()) {
                System.err.println(jobs);
            }
            throw new RuntimeException("Unknown job `" + jobName + "`");
        }
    }

    void printJobInfo(String jobName, Formatter formatter) {
        this.checkJob(jobName);
        String[] builds = JobsRecognition.getNonNullListing(this.creteBuildsDir(jobName));
        ArrayList<Integer> results = new ArrayList<Integer>(builds.length);
        for (String build : builds) {
            if (!JobsRecognition.isNumber(build)) continue;
            results.add(Integer.valueOf(build));
        }
        int latest = this.getLatestBuildId(jobName);
        Collections.sort(results);
        formatter.initDoc();
        for (Integer result : results) {
            formatter.small();
            File f = this.creteBuildDir(jobName, result);
            if (this.isUnknown(f)) {
                formatter.startColor(Formatter.SupportedColors.Magenta);
            } else if (this.isFailed(f)) {
                formatter.startColor(Formatter.SupportedColors.Red);
            } else if (this.isAborted(f)) {
                formatter.startColor(Formatter.SupportedColors.LightMagenta);
            } else if (this.isUnstable(f)) {
                formatter.startColor(Formatter.SupportedColors.Yellow);
            } else if (this.isPassed(f)) {
                formatter.startColor(Formatter.SupportedColors.Green);
            } else {
                formatter.startColor(Formatter.SupportedColors.Cyan);
            }
            formatter.print(result + "(" + (result - latest) + "): ");
            formatter.print(JobsRecognition.getChangelogsNvr(f));
            String tt = JobsRecognition.tail(this.creteLogFile(jobName, result));
            if (tt != null) {
                // empty if block
            }
            formatter.print(" [" + tt + "]");
            if (this.isUnknown(f)) {
                formatter.print(" [unknown status!]");
            }
            formatter.closeBuildsList();
        }
        formatter.closeDoc();
    }

    public static boolean isNumber(String s) {
        try {
            Integer.valueOf(s);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String getChangelogsNvr(File buildPath) {
        File f = JobsRecognition.creteChangelogFile(buildPath);
        String cached = nvrCache.get(f);
        if (cached != null) {
            return cached;
        }
        try {
            String content = new Scanner(f, "UTF-8").useDelimiter("\\Z").next();
            String[] lines = content.split("[<>]");
            boolean read1 = true;
            boolean read2 = false;
            for (String line : lines) {
                if ((line = line.replaceAll("\\s+", "")).isEmpty()) continue;
                if (read1 && read2) {
                    nvrCache.put(f, line);
                    return line;
                }
                if (line.equals("rpms")) {
                    read1 = false;
                }
                if (line.equals("/rpms")) {
                    read1 = true;
                }
                if (line.equals("nvr")) {
                    read2 = true;
                }
                if (!line.equals("/nvr")) continue;
                read2 = false;
            }
        }
        catch (Exception ex) {
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String tail(File file) {
        if (!file.exists()) {
            return null;
        }
        if (cache.get(file) != null) {
            return cache.get(file);
        }
        RandomAccessFile fileHandler = null;
        try {
            fileHandler = new RandomAccessFile(file, "r");
            long fileLength = fileHandler.length() - 1L;
            StringBuilder sb = new StringBuilder();
            for (long filePointer = fileLength; filePointer != -1L; --filePointer) {
                fileHandler.seek(filePointer);
                byte readByte = fileHandler.readByte();
                if (readByte == 10) {
                    if (filePointer != fileLength) break;
                    continue;
                }
                if (readByte == 13) {
                    if (filePointer != fileLength - 1L) break;
                    continue;
                }
                sb.append((char)readByte);
            }
            String lastLine = sb.reverse().toString();
            cache.put(file, lastLine);
            String string = lastLine;
            return string;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (fileHandler != null) {
                try {
                    fileHandler.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean shouldBeSkipped(File f) {
        if (this.isUnknown(f)) {
            return true;
        }
        return this.isAborted(f) || this.isFailed(f);
    }

    public boolean isAborted(File f) {
        return this.ABRTD.matcher(JobsRecognition.tail(JobsRecognition.creteLogFile(f))).matches();
    }

    public boolean isFailed(File f) {
        return this.FAILD.matcher(JobsRecognition.tail(JobsRecognition.creteLogFile(f))).matches();
    }

    public boolean isUnstable(File f) {
        return this.UNSTB.matcher(JobsRecognition.tail(JobsRecognition.creteLogFile(f))).matches();
    }

    public boolean isPassed(File f) {
        return this.PASSD.matcher(JobsRecognition.tail(JobsRecognition.creteLogFile(f))).matches();
    }

    public boolean isUnknown(File f) {
        if (!f.exists()) {
            return true;
        }
        try {
            return !this.isAborted(f) && !this.isFailed(f) && !this.isUnstable(f) && !this.isPassed(f);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return true;
        }
    }

    static {
        cache = new HashMap<File, String>();
        nvrCache = new HashMap<File, String>();
    }
}

