/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.jtreg.formatters;

import io.jenkins.plugins.report.jtreg.formatters.Formatter;
import io.jenkins.plugins.report.jtreg.formatters.StringMappedFormatter;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;

public class HtmlFormatter
extends StringMappedFormatter {
    protected List<String> clossingBuffer = new LinkedList<String>();

    public HtmlFormatter(PrintStream stream) {
        super(stream);
        this.fillColors();
    }

    @Override
    public void print(String s) {
        super.print(this.sanitize(s));
    }

    @Override
    public void println(String s) {
        super.println(this.sanitize(s) + "<br/>");
    }

    private String sanitize(String s) {
        if (s == null) {
            return null;
        }
        return s.replaceAll("  ", "&nbsp; ");
    }

    private void fillColors() {
        this.colors.put(Formatter.SupportedColors.Black, this.template("black"));
        this.colors.put(Formatter.SupportedColors.Red, this.template("red"));
        this.colors.put(Formatter.SupportedColors.Green, this.template("green"));
        this.colors.put(Formatter.SupportedColors.Yellow, this.template("yellow"));
        this.colors.put(Formatter.SupportedColors.Blue, this.template("blue"));
        this.colors.put(Formatter.SupportedColors.Magenta, this.template("magenta"));
        this.colors.put(Formatter.SupportedColors.Cyan, this.template("cyan"));
        this.colors.put(Formatter.SupportedColors.LightRed, this.template("OrangeRed"));
        this.colors.put(Formatter.SupportedColors.LightGreen, this.template("LightGreen"));
        this.colors.put(Formatter.SupportedColors.LightYellow, this.template("LightYellow"));
        this.colors.put(Formatter.SupportedColors.LightBlue, this.template("LightBlue"));
        this.colors.put(Formatter.SupportedColors.LightMagenta, this.template("Violet"));
        this.colors.put(Formatter.SupportedColors.LightCyan, this.template("LightCyan"));
    }

    private String template(String color) {
        return "<span style='color:" + color + "'>";
    }

    @Override
    public void startBold() {
        this.print("<b>");
        this.clossingBuffer.add("</b>");
    }

    @Override
    public void startColor(Formatter.SupportedColors color) {
        this.print(this.getColor(color));
        this.clossingBuffer.add("</span>");
    }

    @Override
    public void reset() {
        while (!this.clossingBuffer.isEmpty()) {
            this.print(this.clossingBuffer.get(this.clossingBuffer.size() - 1));
            this.clossingBuffer.remove(this.clossingBuffer.size() - 1);
        }
    }

    @Override
    public void initDoc() {
        this.println("<div style='background-color:black;color:white'>");
    }

    @Override
    public void closeDoc() {
        this.println("</div>");
    }

    @Override
    public void startTitle2() {
        this.print("<h2>");
        this.clossingBuffer.add("</h2>");
    }

    @Override
    public void startTitle4() {
        this.print("<h4>");
        this.clossingBuffer.add("</h4>");
    }

    @Override
    public void startTitle3() {
        this.print("<h3>");
        this.clossingBuffer.add("</h3>");
    }

    @Override
    public void startTitle1() {
        this.print("<h1>");
        this.clossingBuffer.add("</h1>");
    }

    @Override
    public void pre() {
        this.print("<pre>");
    }

    @Override
    public void preClose() {
        this.print("</pre>");
    }

    @Override
    public void printTable(String[][] table, int rowSize, int columnSize) {
        int i;
        super.println("<style>table, td { border: 1px solid black; border-collapse: collapse; padding: 0.5em; }</style>");
        super.println("<ul>");
        for (i = 1; i < table[0].length; ++i) {
            super.println("<li><b>" + i + ":</b> " + table[0][i] + "</li>");
            table[0][i] = "<b>" + i + "</b>";
        }
        super.println("</ul>");
        super.println("<table>");
        for (i = 0; i < rowSize; ++i) {
            super.println("<tr>");
            for (int j = 0; j < columnSize; ++j) {
                if (table[i][j] != null) {
                    if (table[i][j].equals("X")) {
                        super.println("<td style=\"color:Red\">" + table[i][j] + "</td>");
                        continue;
                    }
                    super.println("<td>" + table[i][j] + "</td>");
                    continue;
                }
                super.println("<td></td>");
            }
            super.println("</tr>");
        }
        super.println("</table>");
    }
}

