/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.jtreg.formatters;

import io.jenkins.plugins.report.jtreg.formatters.Formatter;
import io.jenkins.plugins.report.jtreg.formatters.StringMappedFormatter;
import java.io.PrintStream;
import java.util.Arrays;

public class ColorFormatter
extends StringMappedFormatter {
    private static final String Default = "\u001b[39m";
    private static final String ResetAll = "\u001b[0m";
    private static final String Bold = "\u001b[1m";
    private static final String Black = "\u001b[30m";
    private static final String Red = "\u001b[31m";
    private static final String Green = "\u001b[32m";
    private static final String Yellow = "\u001b[33m";
    private static final String Blue = "\u001b[34m";
    private static final String Magenta = "\u001b[35m";
    private static final String Cyan = "\u001b[36m";
    private static final String LightRed = "\u001b[91m";
    private static final String LightGreen = "\u001b[92m";
    private static final String LightYellow = "\u001b[93m";
    private static final String LightBlue = "\u001b[94m";
    private static final String LightMagenta = "\u001b[95m";
    private static final String LightCyan = "\u001b[96m";

    private void fillColors() {
        this.colors.put(Formatter.SupportedColors.Black, Black);
        this.colors.put(Formatter.SupportedColors.Red, Red);
        this.colors.put(Formatter.SupportedColors.Green, Green);
        this.colors.put(Formatter.SupportedColors.Yellow, Yellow);
        this.colors.put(Formatter.SupportedColors.Blue, Blue);
        this.colors.put(Formatter.SupportedColors.Magenta, Magenta);
        this.colors.put(Formatter.SupportedColors.Cyan, Cyan);
        this.colors.put(Formatter.SupportedColors.LightRed, LightRed);
        this.colors.put(Formatter.SupportedColors.LightGreen, LightGreen);
        this.colors.put(Formatter.SupportedColors.LightYellow, LightYellow);
        this.colors.put(Formatter.SupportedColors.LightBlue, LightBlue);
        this.colors.put(Formatter.SupportedColors.LightMagenta, LightMagenta);
        this.colors.put(Formatter.SupportedColors.LightCyan, LightCyan);
    }

    public ColorFormatter(PrintStream stream) {
        super(stream);
        this.fillColors();
    }

    @Override
    public void startBold() {
        this.print(Bold);
    }

    @Override
    public void startColor(Formatter.SupportedColors color) {
        this.print(this.getColor(color));
    }

    @Override
    public void reset() {
        this.print(ResetAll);
        this.preset();
    }

    @Override
    public void initDoc() {
        this.reset();
    }

    @Override
    public void closeDoc() {
        this.print(ResetAll);
    }

    private void preset() {
        this.print("\u001b[49m");
        this.print("\u001b[97m");
    }

    @Override
    public void startTitle2() {
        this.startColor(Formatter.SupportedColors.Cyan);
    }

    @Override
    public void startTitle1() {
        this.startColor(Formatter.SupportedColors.Cyan);
        this.startBold();
    }

    @Override
    public void startTitle3() {
        this.startColor(Formatter.SupportedColors.LightBlue);
    }

    @Override
    public void startTitle4() {
        this.startColor(Formatter.SupportedColors.Blue);
    }

    @Override
    public void printTable(String[][] table, int rowSize, int columnSize) {
        int j;
        int i;
        for (int i2 = 1; i2 < table[0].length; ++i2) {
            super.println(Bold + i2 + ") \u001b[0m" + table[0][i2]);
            table[0][i2] = Integer.toString(i2);
        }
        int[] lengths = new int[table[0].length];
        Arrays.fill(lengths, 0);
        for (i = 0; i < rowSize; ++i) {
            for (j = 0; j < columnSize; ++j) {
                if (table[i][j] == null || table[i][j].length() <= lengths[j]) continue;
                lengths[j] = table[i][j].length();
            }
        }
        for (i = 0; i < rowSize; ++i) {
            for (j = 0; j < columnSize; ++j) {
                int len = 0;
                if (table[i][j] != null) {
                    if (i == 0) {
                        super.print(Bold + table[i][j] + "\u001b[0m ");
                    } else if (table[i][j].equals("X")) {
                        super.print(Red + table[i][j] + "\u001b[0m ");
                    } else {
                        super.print(table[i][j] + " ");
                    }
                    len = table[i][j].length();
                } else {
                    super.print(" ");
                }
                for (int k = len; k < lengths[j]; ++k) {
                    super.print(" ");
                }
                super.print("| ");
            }
            super.print("\n");
        }
    }
}

