/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.jtreg;

import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Project;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import io.jenkins.plugins.report.jtreg.AbstractReportPublisher;
import io.jenkins.plugins.report.jtreg.BuildSummaryParserPlugin;
import io.jenkins.plugins.report.jtreg.ReportAction;
import io.jenkins.plugins.report.jtreg.model.BuildReport;
import io.jenkins.plugins.report.jtreg.model.BuildReportPlugin;
import io.jenkins.plugins.report.jtreg.model.ProjectReport;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ReportProjectAction
implements Action {
    private final Job<?, ?> job;
    private final Set<String> prefixes = new HashSet<String>();
    private static final String CACHEDSUMMREGRESSIONSPROPERTIES = "cached-summ-regressions.properties";
    private static final String CACHEDSUMMRESULTSPROPERTIES = "cached-summ-results.properties";

    public ReportProjectAction(Job<?, ?> job, Set<String> prefixes) {
        if (job == null) {
            throw new IllegalArgumentException("Job cannot be null");
        }
        if (prefixes == null || prefixes.isEmpty()) {
            throw new IllegalArgumentException("Prefixes cannot be null or empty");
        }
        this.job = job;
        this.prefixes.addAll(prefixes);
    }

    public void addPrefix(String prefix) {
        this.prefixes.add(prefix);
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        AbstractReportPublisher settings = ReportAction.getAbstractReportPublisher((DescribableList<Publisher, Descriptor<Publisher>>)((Project)this.job).getPublishersList());
        List<String> blisted = new BuildSummaryParserPlugin(this.prefixes, settings).getDenylisted(this.job);
        List<String> wlisted = new BuildSummaryParserPlugin(this.prefixes, settings).getAllowlisted(this.job);
        int allowListSizeWithoutSurroundings = new BuildSummaryParserPlugin(this.prefixes, settings).getAllowListSizeWithoutSurroundings(this.job);
        Object appendix = "";
        if (blisted.size() > 0 && wlisted.size() > 0) {
            appendix = " (denylisted " + blisted.size() + ") (allowlisted " + allowListSizeWithoutSurroundings + "/" + Integer.toString(wlisted.size() - allowListSizeWithoutSurroundings) + ")";
        } else if (blisted.size() > 0) {
            appendix = " (denylisted " + blisted.size() + ")";
        } else if (wlisted.size() > 0) {
            appendix = " (allowlisted " + allowListSizeWithoutSurroundings + "/" + Integer.toString(wlisted.size() - allowListSizeWithoutSurroundings) + ")";
        }
        return ((Stream)this.prefixes.stream().sequential()).map(s -> s.toUpperCase()).collect(Collectors.joining(", ", "", " Reports" + (String)appendix));
    }

    public String getUrlName() {
        return "java-reports";
    }

    public ProjectReport getChartData() {
        AbstractReportPublisher settings = ReportAction.getAbstractReportPublisher((DescribableList<Publisher, Descriptor<Publisher>>)((Project)this.job).getPublishersList());
        List<BuildReportPlugin> reports = new BuildSummaryParserPlugin(this.prefixes, settings).parseJobReports(this.job);
        ProjectReport report = new ProjectReport(reports, this.collectImprovements(reports), this.collectRegressions(reports));
        ReportProjectAction.cacheTotals(((Project)this.job).getRootDir(), report);
        return report;
    }

    private List<Integer> collectImprovements(List<? extends BuildReport> reports) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Set<String> prev = null;
        for (BuildReport buildReport : reports) {
            if (prev == null) {
                prev = this.collectTestNames(buildReport);
                result.add(0);
                continue;
            }
            Set<String> current = this.collectTestNames(buildReport);
            long count = ((Stream)prev.stream().sequential()).filter(s -> !current.contains(s)).count();
            result.add((int)count);
            prev = current;
        }
        return result;
    }

    private List<Integer> collectRegressions(List<? extends BuildReport> reports) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Set<String> prev = null;
        for (BuildReport buildReport : reports) {
            if (prev == null) {
                prev = this.collectTestNames(buildReport);
                result.add(0);
                continue;
            }
            Set<String> current = this.collectTestNames(buildReport);
            HashSet<String> finalPrev = new HashSet<String>(prev);
            long count = ((Stream)current.stream().sequential()).filter(s -> !finalPrev.contains(s)).count();
            result.add((int)count);
            prev = current;
        }
        return result;
    }

    private Set<String> collectTestNames(BuildReport report) {
        return ((Stream)report.getSuites().stream().sequential()).filter(s -> s.getReport().getTestProblems() != null).filter(s -> s.getReport().getTestProblems().size() > 0).flatMap(s -> ((Stream)s.getReport().getTestProblems().stream().sequential()).map(t -> s.getName() + " / " + t.getName())).collect(Collectors.toSet());
    }

    public static void cacheTotals(File rootBuild, ProjectReport projectRreport) {
        try {
            ReportProjectAction.cacheTotalsImpl(rootBuild, projectRreport);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    static void cacheTotalsImpl(File rootBuild, ProjectReport projectRreport) throws IOException {
        ReportProjectAction.cacheSumms(rootBuild, projectRreport.getReports());
        for (int i = 0; i < projectRreport.getReports().size(); ++i) {
            BuildReport buildReport = projectRreport.getReports().get(i);
            File cachedRegressions = ReportProjectAction.getCachedRegressionsFile(rootBuild, buildReport);
            if (cachedRegressions.exists()) continue;
            try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cachedRegressions), "utf-8"));){
                bw.write("jrp.improvements=" + projectRreport.getImprovements().get(i));
                bw.newLine();
                bw.write("jrp.regressions=" + projectRreport.getRegressions().get(i));
                bw.newLine();
                continue;
            }
        }
    }

    private static File getCachedRegressionsFile(File rootBuild, BuildReport buildReport) {
        return ReportProjectAction.getCachedFile(rootBuild, buildReport, CACHEDSUMMREGRESSIONSPROPERTIES);
    }

    private static File getCachedResultsFile(File rootBuild, BuildReport report) {
        return ReportProjectAction.getCachedFile(rootBuild, report, CACHEDSUMMRESULTSPROPERTIES);
    }

    private static File getCachedFile(File root, BuildReport report, String name) {
        return new File(new File(new File(root, "builds"), "" + report.getBuildNumber()), name);
    }

    static void cacheSumms(File rootBuild, List<? extends BuildReport> reports) throws IOException {
        for (BuildReport buildReport : reports) {
            File cachedResults = ReportProjectAction.getCachedResultsFile(rootBuild, buildReport);
            if (cachedResults.exists()) continue;
            try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cachedResults), "utf-8"));){
                bw.write("jrp.errors=" + buildReport.getError());
                bw.newLine();
                bw.write("jrp.failures=" + buildReport.getFailed());
                bw.newLine();
                bw.write("jrp.notrun=" + buildReport.getNotRun());
                bw.newLine();
                bw.write("jrp.passed=" + buildReport.getPassed());
                bw.newLine();
                bw.write("jrp.total=" + buildReport.getTotal());
                bw.newLine();
                bw.write("jrp.failedAndErrors=" + (buildReport.getFailed() + buildReport.getError()));
                bw.newLine();
            }
        }
    }
}

