/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.jtreg;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import io.jenkins.plugins.report.jtreg.model.Report;
import io.jenkins.plugins.report.jtreg.model.Suite;
import io.jenkins.plugins.report.jtreg.parsers.ReportParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.PathMatcher;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.MasterToSlaveFileCallable;

public class ReportParserCallable
extends MasterToSlaveFileCallable<List<Suite>>
implements FilePath.FileCallable<List<Suite>> {
    public static final Suite FAKE_SUITE = new Suite("Fake suite", new Report(0, 0, 0, 0, 0, null));
    private final String reportMatcherGlob;
    private final ReportParser reportParser;

    public ReportParserCallable(String reportMatcherGlob, ReportParser reportParser) {
        this.reportParser = reportParser;
        if (reportMatcherGlob == null || ((String)reportMatcherGlob).isEmpty()) {
            this.reportMatcherGlob = "glob:*.{xml,xml.gz}";
        } else {
            if (!((String)reportMatcherGlob).startsWith("glob:")) {
                reportMatcherGlob = "glob:" + (String)reportMatcherGlob;
            }
            this.reportMatcherGlob = reportMatcherGlob;
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE", "RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification=" npe of spotbugs sucks")
    public List<Suite> invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher(this.reportMatcherGlob);
        try (Stream filesStream = (Stream)Files.walk(f.toPath(), new FileVisitOption[0]).sequential();){
            List<Suite> result = filesStream.filter(p -> pathMatcher.matches(p.getFileName())).map(this.reportParser::parsePath).filter(e -> e != null).sorted().collect(Collectors.toList());
            if (result != null && result.size() == 0) {
                result.add(this.getFakeSuite());
            }
            List<Suite> list = result;
            return list;
        }
    }

    private Suite getFakeSuite() {
        return FAKE_SUITE;
    }
}

