/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.jtreg;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Project;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import io.jenkins.plugins.report.jtreg.AbstractReportPublisher;
import io.jenkins.plugins.report.jtreg.BuildSummaryParserPlugin;
import io.jenkins.plugins.report.jtreg.ReportAction;
import io.jenkins.plugins.report.jtreg.ReportProjectAction;
import io.jenkins.plugins.report.jtreg.model.BuildReport;
import io.jenkins.plugins.report.jtreg.model.BuildReportPlugin;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.kohsuke.stapler.DataBoundConstructor;

public class ReportChartColumn
extends ListViewColumn {
    @Extension
    public static final ReportChartColumnDescriptor DESCRIPTOR = new ReportChartColumnDescriptor();

    @DataBoundConstructor
    public ReportChartColumn() {
    }

    public List<BuildReportPlugin> getJckReport(Job<?, ?> job) {
        AbstractReportPublisher settings = ReportAction.getAbstractReportPublisher((DescribableList<Publisher, Descriptor<Publisher>>)((Project)job).getPublishersList());
        List<BuildReportPlugin> r = new BuildSummaryParserPlugin(Arrays.asList("jck", "jtreg"), settings).parseJobReports(job);
        try {
            ReportProjectAction.cacheSumms(job.getRootDir(), r);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return r;
    }

    public int getLatestResultFailures(List<BuildReport> reports) {
        if (reports == null || reports.isEmpty()) {
            return 0;
        }
        BuildReport lastReport = reports.get(reports.size() - 1);
        return lastReport.getFailed() + lastReport.getError();
    }

    public String generateChartName() {
        return "chart" + UUID.randomUUID().toString().replace("-", "");
    }

    public static class ReportChartColumnDescriptor
    extends ListViewColumnDescriptor {
        public boolean shownByDefault() {
            return false;
        }

        public String getDisplayName() {
            return "JCK and/or JTreg Results";
        }
    }
}

