/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.jtreg;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import io.jenkins.plugins.report.jtreg.AbstractReportPublisher;
import io.jenkins.plugins.report.jtreg.BuildReportExtended;
import io.jenkins.plugins.report.jtreg.BuildSummaryParserPlugin;
import io.jenkins.plugins.report.jtreg.ReportProjectAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.StaplerProxy;

public class ReportAction
implements Action,
StaplerProxy,
SimpleBuildStep.LastBuildAction {
    private final AbstractBuild<?, ?> build;
    private final Set<String> prefixes = new HashSet<String>();

    public ReportAction(AbstractBuild<?, ?> build) {
        if (build == null) {
            throw new IllegalArgumentException("Build cannot be null");
        }
        this.build = build;
    }

    public void addPrefix(String prefix) {
        if (prefix == null || prefix.trim().isEmpty()) {
            throw new IllegalArgumentException("Prefix cannot be empty");
        }
        this.prefixes.add(prefix);
    }

    public String getIconFileName() {
        return "graph.png";
    }

    public String getDisplayName() {
        return ((Stream)this.prefixes.stream().sequential()).map(s -> s.toUpperCase()).collect(Collectors.joining(", ", "", " Reports"));
    }

    public String getUrlName() {
        return "java-reports";
    }

    public BuildReportExtended getTarget() {
        try {
            AbstractReportPublisher settings = ReportAction.getAbstractReportPublisher((DescribableList<Publisher, Descriptor<Publisher>>)this.build.getProject().getPublishersList());
            BuildReportExtended report = new BuildSummaryParserPlugin(this.prefixes, settings).parseBuildReportExtended((Run<?, ?>)this.build);
            return report;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Collection<? extends Action> getProjectActions() {
        Job job = this.build.getParent();
        return Collections.singleton(new ReportProjectAction(job, this.prefixes));
    }

    public static AbstractReportPublisher getAbstractReportPublisher(DescribableList<Publisher, Descriptor<Publisher>> publishersList) {
        for (Publisher publisher : publishersList) {
            if (!(publisher instanceof AbstractReportPublisher)) continue;
            return (AbstractReportPublisher)publisher;
        }
        return null;
    }
}

