/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.jtreg;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import io.jenkins.plugins.report.jtreg.AbstractReportPublisher;
import io.jenkins.plugins.report.jtreg.parsers.JtregReportParser;
import io.jenkins.plugins.report.jtreg.parsers.ReportParser;
import org.kohsuke.stapler.DataBoundConstructor;

public class JtregReportPublisher
extends AbstractReportPublisher {
    public static final String sfxs = "zip,tar,tar.gz,tar.bz2,tar.xz";
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public JtregReportPublisher(String reportFileGlob) {
        super(reportFileGlob);
    }

    public static boolean isJtregArchive(String s) {
        String[] ss;
        for (String s1 : ss = sfxs.split(",")) {
            if (!s.endsWith(s1)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String defaultReportFileGlob() {
        return "glob:*.{zip,tar,tar.gz,tar.bz2,tar.xz}";
    }

    @Override
    protected ReportParser createReportParser() {
        return new JtregReportParser();
    }

    @Override
    protected String prefix() {
        return "jtreg";
    }

    public BuildStepDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return "JTreg Report";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

