/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.jtreg;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.util.RunList;
import io.jenkins.plugins.report.jtreg.AbstractReportPublisher;
import io.jenkins.plugins.report.jtreg.BuildReportExtended;
import io.jenkins.plugins.report.jtreg.BuildReportExtendedPluginFactory;
import io.jenkins.plugins.report.jtreg.BuildSummaryParser;
import io.jenkins.plugins.report.jtreg.model.BuildReport;
import io.jenkins.plugins.report.jtreg.model.BuildReportPlugin;
import io.jenkins.plugins.report.jtreg.model.SuiteTests;
import io.jenkins.plugins.report.jtreg.wrappers.RunWrapperFromRun;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class BuildSummaryParserPlugin
extends BuildSummaryParser {
    private final AbstractReportPublisher settings;

    public BuildSummaryParserPlugin(Collection<String> prefixes, AbstractReportPublisher settings) {
        super(prefixes);
        this.prefixes.addAll(prefixes);
        this.settings = settings;
        this.buildReportExtendedFactory = new BuildReportExtendedPluginFactory();
    }

    List<String> getDenylisted(Job<?, ?> job) {
        return this.getDenylisted(job.getBuilds());
    }

    List<String> getAllowlisted(Job<?, ?> job) {
        return this.getAllowlisted(job.getBuilds());
    }

    int getAllowListSizeWithoutSurroundings(Job<?, ?> job) {
        return this.getAllowListSizeWithoutSurroundings(job.getBuilds()).size();
    }

    List<String> getDenylisted(RunList<?> runs) {
        return this.getList(runs, new ListProvider(){

            @Override
            public String getList() {
                if (BuildSummaryParserPlugin.this.settings == null) {
                    return "";
                }
                return BuildSummaryParserPlugin.this.settings.getResultsDenyList();
            }

            @Override
            public int getSurrounding() {
                return 0;
            }
        });
    }

    List<String> getAllowlisted(RunList<?> runs) {
        return this.getList(runs, new ListProvider(){

            @Override
            public String getList() {
                if (BuildSummaryParserPlugin.this.settings == null) {
                    return "";
                }
                return BuildSummaryParserPlugin.this.settings.getResultsAllowList();
            }

            @Override
            public int getSurrounding() {
                return BuildSummaryParserPlugin.this.settings.getRangeAroundAlist();
            }
        });
    }

    List<String> getAllowListSizeWithoutSurroundings(RunList<?> runs) {
        return this.getList(runs, new ListProvider(){

            @Override
            public String getList() {
                return BuildSummaryParserPlugin.this.settings.getResultsAllowList();
            }

            @Override
            public int getSurrounding() {
                return 0;
            }
        });
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE", "RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification=" npe of spotbugs sucks")
    List<String> getList(RunList<?> runs, ListProvider provider) {
        String list = provider.getList();
        if (this.settings == null || list == null || list.trim().isEmpty()) {
            return Collections.emptyList();
        }
        int limit = this.getMaxItems();
        ArrayList<String> listed = new ArrayList<String>(limit);
        Run[] builds = (Run[])runs.toArray((Object[])new Run[0]);
        for (int i = 0; i < builds.length; ++i) {
            String[] items;
            Run run = builds[i];
            if (run.getResult() == null || run.getResult().isWorseThan(Result.UNSTABLE)) continue;
            for (String item : items = list.split("\\s+")) {
                int j;
                if (!run.getDisplayName().matches(item)) continue;
                int numberOfFailedBuilds = 0;
                for (j = 0; j <= provider.getSurrounding() + numberOfFailedBuilds; ++j) {
                    if (!this.addNotFailedBuild(i + j, listed, builds)) continue;
                    ++numberOfFailedBuilds;
                }
                numberOfFailedBuilds = 0;
                for (j = -1; j >= -(provider.getSurrounding() + numberOfFailedBuilds); --j) {
                    if (!this.addNotFailedBuild(i + j, listed, builds)) continue;
                    ++numberOfFailedBuilds;
                }
            }
        }
        return listed;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE", "RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification=" npe of spotbugs sucks")
    private boolean addNotFailedBuild(int position, List<String> result, Run[] builds) {
        if (position >= 0 && position < builds.length) {
            boolean crashed;
            boolean bl = crashed = builds[position].getResult() == null || builds[position].getResult().isWorseThan(Result.UNSTABLE);
            if (crashed) {
                return true;
            }
            if (!result.contains(builds[position].getDisplayName())) {
                result.add(builds[position].getDisplayName());
            }
        }
        return false;
    }

    private int getMaxItems() {
        int limit = 10;
        if (this.settings != null) {
            limit = this.settings.getIntMaxBuilds();
        }
        return limit;
    }

    public List<BuildReportPlugin> parseJobReports(Job<?, ?> job) {
        return this.parseJobReports(job.getBuilds());
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE", "RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification=" npe of spotbugs sucks")
    public List<BuildReportPlugin> parseJobReports(RunList<?> runs) {
        int limit = this.getMaxItems();
        ArrayList<BuildReportPlugin> list = new ArrayList<BuildReportPlugin>();
        List<String> denylisted = this.getDenylisted(runs);
        List<String> allowlisted = this.getAllowlisted(runs);
        for (Run run : runs) {
            if (run.getResult() == null || run.getResult().isWorseThan(Result.UNSTABLE) || denylisted.contains(run.getDisplayName()) || !allowlisted.contains(run.getDisplayName()) && !allowlisted.isEmpty()) continue;
            try {
                BuildReport report = this.parseBuildReport(run);
                if (!report.isInvalid()) {
                    list.add(new BuildReportPlugin(report.getBuildNumber(), report.getBuildName(), report.getPassed(), report.getFailed(), report.getError(), report.getSuites(), report.getTotal(), report.getBuildNumber()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (list.size() != limit) continue;
            break;
        }
        Collections.reverse(list);
        return list;
    }

    public BuildReport parseBuildReport(Run<?, ?> build) throws Exception {
        return this.parseBuildReport(new RunWrapperFromRun(build));
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE", "RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification=" npe of spotbugs sucks")
    public BuildReportExtended parseBuildReportExtended(Run<?, ?> build) throws Exception {
        int i;
        AbstractProject project = ((AbstractBuild)build).getProject();
        Run[] builds = (Run[])project.getBuilds().toArray((Object[])new Run[0]);
        RunWrapperFromRun previousPassedOrUnstable = null;
        int thisInArray = -1;
        for (i = 0; i < builds.length; ++i) {
            if (!builds[i].equals(build)) continue;
            thisInArray = i;
            break;
        }
        if (thisInArray == -1) {
            System.err.println("Warning " + build.toString() + " not found in builds of #" + builds.length);
        }
        for (i = thisInArray + 1; i < builds.length; ++i) {
            Run run = builds[i];
            if (run == null || run.getResult() == null || run.getResult().isWorseThan(Result.UNSTABLE)) continue;
            previousPassedOrUnstable = new RunWrapperFromRun(run);
            break;
        }
        return this.parseBuildReportExtended(new RunWrapperFromRun(build), previousPassedOrUnstable);
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Alhoug never called, this method is here to demonstrate (and ocassionally being used) how to access the root dir from run/build")
    private List<SuiteTests> parseSuiteTests(Run<?, ?> build) throws Exception {
        return this.parseSuiteTests(build.getRootDir());
    }

    private static interface ListProvider {
        public String getList();

        public int getSurrounding();
    }
}

