/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.jtreg;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.jenkins.plugins.report.jtreg.BuildReportExtended;
import io.jenkins.plugins.report.jtreg.BuildReportExtendedFactory;
import io.jenkins.plugins.report.jtreg.model.BuildReport;
import io.jenkins.plugins.report.jtreg.model.Report;
import io.jenkins.plugins.report.jtreg.model.Suite;
import io.jenkins.plugins.report.jtreg.model.SuiteTestChanges;
import io.jenkins.plugins.report.jtreg.model.SuiteTests;
import io.jenkins.plugins.report.jtreg.model.SuitesWithResults;
import io.jenkins.plugins.report.jtreg.model.TestStatus;
import io.jenkins.plugins.report.jtreg.wrappers.RunWrapper;
import io.jenkins.plugins.report.jtreg.wrappers.RunWrapperFromDir;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BuildSummaryParser {
    protected final Set<String> prefixes = new HashSet<String>();
    protected BuildReportExtendedFactory buildReportExtendedFactory;

    public BuildSummaryParser(Collection<String> prefixes) {
        if (prefixes == null || prefixes.isEmpty()) {
            throw new IllegalArgumentException("Prefixes cannot be null or empty");
        }
        this.prefixes.addAll(prefixes);
        this.buildReportExtendedFactory = new BuildReportExtendedFactory();
    }

    public BuildReport parseJobReports(File dir1) {
        try {
            return this.parseBuildReport(new RunWrapperFromDir(dir1));
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
            return null;
        }
    }

    public BuildReport parseBuildReport(RunWrapper build) throws Exception {
        List<Suite> suites = this.parseBuildSummary(build.getRoot());
        int passed = 0;
        int failed = 0;
        int error = 0;
        int total = 0;
        int notRun = 0;
        for (Suite suite : suites) {
            passed += suite.getReport().getTestsPassed();
            failed += suite.getReport().getTestsFailed();
            error += suite.getReport().getTestsError();
            total += suite.getReport().getTestsTotal();
            notRun += suite.getReport().getTestsNotRun();
        }
        return new BuildReport(build.getNumber(), build.getName(), passed, failed, error, suites, total, notRun);
    }

    public BuildReportExtended parseBuildReportExtended(RunWrapper build, RunWrapper previousPassedOrUnstable) throws Exception {
        List<SuiteTests> currentBuildTestsList = this.parseSuiteTests(build.getRoot());
        List<Object> prevBuildTestsList = previousPassedOrUnstable != null ? this.parseSuiteTests(previousPassedOrUnstable.getRoot()) : new ArrayList();
        Set prevSuites = ((Stream)prevBuildTestsList.stream().sequential()).map(s -> s.getName()).collect(Collectors.toSet());
        List<String> addedSuites = ((Stream)currentBuildTestsList.stream().sequential()).map(s -> s.getName()).filter(s -> !prevSuites.contains(s)).collect(Collectors.toList());
        Set currentSuites = ((Stream)currentBuildTestsList.stream().sequential()).map(s -> s.getName()).collect(Collectors.toSet());
        List<String> removedSuites = ((Stream)prevBuildTestsList.stream().sequential()).map(s -> s.getName()).filter(s -> !currentSuites.contains(s)).collect(Collectors.toList());
        ArrayList<SuiteTestChanges> result = new ArrayList<SuiteTestChanges>();
        BuildReport currentReport = this.parseBuildReport(build);
        if (previousPassedOrUnstable != null) {
            BuildReport previousReport = this.parseBuildReport(previousPassedOrUnstable);
            Map<String, Report> prevReportsMap = ((Stream)previousReport.getSuites().stream().sequential()).collect(Collectors.toMap(s -> s.getName(), s -> s.getReport()));
            for (Suite suite : currentReport.getSuites()) {
                if (!prevReportsMap.containsKey(suite.getName())) continue;
                Set currentFailedEroredTests = ((Stream)suite.getReport().getTestProblems().stream().sequential()).map(t -> t.getName()).collect(Collectors.toSet());
                Set currentTestsDescriptors = ((Stream)suite.getReport().getTestProblems().stream().sequential()).map(t -> new TestDescriptor(t.getName(), t.getStatus())).collect(Collectors.toSet());
                currentTestsDescriptors.addAll(((Stream)currentBuildTestsList.stream().sequential()).filter(s -> suite.getName().equals(s.getName())).flatMap(s -> s.getTests().stream()).filter(s -> !currentFailedEroredTests.contains(s)).map(s -> new TestDescriptor((String)s, TestStatus.PASSED)).collect(Collectors.toList()));
                Set previousFailedErroredTests = ((Stream)prevReportsMap.get(suite.getName()).getTestProblems().stream().sequential()).map(t -> t.getName()).collect(Collectors.toSet());
                Set previousTestsDescriptors = ((Stream)prevReportsMap.get(suite.getName()).getTestProblems().stream().sequential()).map(t -> new TestDescriptor(t.getName(), t.getStatus())).collect(Collectors.toSet());
                previousTestsDescriptors.addAll(((Stream)prevBuildTestsList.stream().sequential()).filter(s -> suite.getName().equals(s.getName())).flatMap(s -> s.getTests().stream()).filter(s -> !previousFailedErroredTests.contains(s)).map(s -> new TestDescriptor((String)s, TestStatus.PASSED)).collect(Collectors.toList()));
                List testChanges = ((Stream)currentTestsDescriptors.stream().sequential()).filter(t -> !previousTestsDescriptors.contains(t)).collect(Collectors.toList());
                Set previousTests = ((Stream)previousTestsDescriptors.stream().sequential()).map(d -> d.name).collect(Collectors.toSet());
                Set currentTests = ((Stream)currentTestsDescriptors.stream().sequential()).map(d -> d.name).collect(Collectors.toSet());
                SuiteTestChanges changes = new SuiteTestChanges(suite.getName(), ((Stream)testChanges.stream().sequential()).filter(t -> t.status == TestStatus.FAILED).map(t -> t.name).collect(Collectors.toList()), ((Stream)testChanges.stream().sequential()).filter(t -> t.status == TestStatus.ERROR).map(t -> t.name).collect(Collectors.toList()), ((Stream)testChanges.stream().sequential()).filter(t -> t.status == TestStatus.PASSED).map(t -> t.name).collect(Collectors.toList()), ((Stream)currentTests.stream().sequential()).filter(s -> !previousTests.contains(s)).sorted().collect(Collectors.toList()), ((Stream)previousTests.stream().sequential()).filter(s -> !currentTests.contains(s)).sorted().collect(Collectors.toList()));
                result.add(changes);
            }
        }
        SuitesWithResults allTests = null;
        String job = build.getRoot().getParentFile().getParentFile().getName();
        try {
            allTests = SuitesWithResults.create(currentBuildTestsList, this.parseBuildReport(build), job, build.getNumber());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.buildReportExtendedFactory.createBuildReportExtended(currentReport.getBuildNumber(), currentReport.getBuildName(), currentReport.getPassed(), currentReport.getFailed(), currentReport.getError(), currentReport.getSuites(), addedSuites, removedSuites, result, currentReport.getTotal(), currentReport.getNotRun(), allTests, job);
    }

    protected List<Suite> parseBuildSummary(File rootDir) throws Exception {
        ArrayList<Suite> result = new ArrayList<Suite>();
        for (String prefix : this.prefixes) {
            File reportFile = new File(rootDir, prefix + "-report.json");
            if (!reportFile.exists() || !reportFile.isFile() || !reportFile.canRead()) continue;
            try (InputStreamReader in = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(reportFile)), StandardCharsets.UTF_8);){
                List list = (List)new Gson().fromJson((Reader)in, new TypeToken<List<Suite>>(){}.getType());
                result.addAll(list);
            }
        }
        return result;
    }

    public List<SuiteTests> parseSuiteTests(File build) throws Exception {
        ArrayList<SuiteTests> result = new ArrayList<SuiteTests>();
        for (String prefix : this.prefixes) {
            File suiteTestsFile = new File(build, prefix + "-tests-list.json");
            if (!suiteTestsFile.exists() || !suiteTestsFile.isFile() || !suiteTestsFile.canRead()) continue;
            try (InputStreamReader in = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(suiteTestsFile)), StandardCharsets.UTF_8);){
                List list = (List)new Gson().fromJson((Reader)in, new TypeToken<List<SuiteTests>>(){}.getType());
                result.addAll(list);
            }
        }
        return result;
    }

    protected static class TestDescriptor {
        protected final String name;
        protected final TestStatus status;

        public TestDescriptor(String name, TestStatus status) {
            this.name = name;
            this.status = status;
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + Objects.hashCode(this.name);
            hash = 79 * hash + Objects.hashCode((Object)this.status);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestDescriptor other = (TestDescriptor)obj;
            if (!Objects.equals(this.name, other.name)) {
                return false;
            }
            return this.status == other.status;
        }
    }
}

