/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.jtreg;

import io.jenkins.plugins.report.jtreg.BuildReportExtended;
import io.jenkins.plugins.report.jtreg.ComparatorLinksGroup;
import io.jenkins.plugins.report.jtreg.JenkinsReportJckGlobalConfig;
import io.jenkins.plugins.report.jtreg.LinkToComparator;
import io.jenkins.plugins.report.jtreg.model.Suite;
import io.jenkins.plugins.report.jtreg.model.SuiteTestChanges;
import io.jenkins.plugins.report.jtreg.model.SuiteTestsWithResultsPlugin;
import io.jenkins.plugins.report.jtreg.model.SuitesWithResults;
import io.jenkins.plugins.report.jtreg.model.Test;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BuildReportExtendedPlugin
extends BuildReportExtended {
    private final String job;

    public BuildReportExtendedPlugin(int buildNumber, String buildName, int passed, int failed, int error, List<Suite> suites, List<String> addedSuites, List<String> removedSuites, List<SuiteTestChanges> testChanges, int total, int notRun, SuitesWithResults allTests, String job) {
        super(buildNumber, buildName, passed, failed, error, suites, addedSuites, removedSuites, testChanges, total, notRun, allTests, job);
        this.job = job;
    }

    public List<ComparatorLinksGroup> getMatchedComparatorLinksGroups() {
        ArrayList<ComparatorLinksGroup> matchedComparatorLinksGroup = new ArrayList<ComparatorLinksGroup>();
        for (ComparatorLinksGroup link : JenkinsReportJckGlobalConfig.getGlobalComparatorLinksGroups()) {
            if (!this.job.matches(link.getJobMatchRegex())) continue;
            matchedComparatorLinksGroup.add(link);
        }
        return matchedComparatorLinksGroup;
    }

    public String createComparatorLinkUrl(String comparatorUrl, LinkToComparator ltc) {
        StringBuilder url = new StringBuilder();
        for (String arg : ltc.getComparatorArguments().split("(\\n|\\r\\n)")) {
            url.append(this.parseQueryToText(ltc.getSpliterator(), arg));
            url.append(" ");
        }
        return comparatorUrl + URLEncoder.encode(url.toString(), StandardCharsets.UTF_8);
    }

    private String parseQueryToText(String spliterator, String query) {
        String[] splitJob = this.job.split(spliterator);
        String converted = query;
        Pattern p = Pattern.compile("%\\{(N?[+-]?[0-9]+|N|S|SPLIT)\\}");
        Matcher m = p.matcher(converted);
        while (m.find()) {
            String replacement;
            String insideBrackets = converted.substring(m.start() + 1 + 1, m.end() - 1);
            if (insideBrackets.equals("S") || insideBrackets.equals("SPLIT")) {
                replacement = spliterator;
            } else {
                int number = insideBrackets.charAt(0) == 'N' && insideBrackets.length() > 1 ? splitJob.length + Integer.parseInt(insideBrackets.substring(1)) : (insideBrackets.charAt(0) == 'N' ? splitJob.length : Integer.parseInt(insideBrackets) - 1);
                if (number < 0 || number >= splitJob.length) {
                    System.err.println("WARNING: The number given in the --regex argument of \"Comparator links\" section is out of range of the job name!");
                    return "The number given is out of range of the job name!";
                }
                replacement = splitJob[number];
            }
            converted = m.replaceFirst(replacement);
            m = p.matcher(converted);
        }
        return converted;
    }

    private static String getDiffUrlStub() {
        return SuiteTestsWithResultsPlugin.getDiffServer() + "?generated-part=+-view%3Ddiff-list+++-view%3Ddiff-summary+++-view%3Ddiff-summary-suites+++-view%3Dinfo-problems+++-view%3Dinfo-summary+++-output%3Dhtml++-fill++&custom-part=";
    }

    public String getLinkDiff() {
        return BuildReportExtendedPlugin.getDiffUrlStub() + this.getJob() + "+" + this.getBuildNumber() + "+" + this.lowestBuildForFil();
    }

    private int lowestBuildForFil() {
        if (this.getBuildNumber() > 10) {
            return this.getBuildNumber() - 10;
        }
        return 1;
    }

    private static String getTracesUrlStub() {
        return SuiteTestsWithResultsPlugin.getDiffServer() + "?generated-part=+-view%3Dinfo+++-output%3Dhtml++&custom-part=";
    }

    public static String getCompUrlStub() {
        return SuiteTestsWithResultsPlugin.getCompServer() + "?generated-part=&custom-part=";
    }

    public String getLinkTraces() {
        return BuildReportExtendedPlugin.getTracesUrlStub() + this.getJob() + "+" + this.getBuildNumber();
    }

    public boolean isDiffTool() {
        return JenkinsReportJckGlobalConfig.isGlobalDiffUrl();
    }

    private static String createDiffUrl() {
        return SuiteTestsWithResultsPlugin.getDiffServer() + "?generated-part=+-view%3Dall-tests+++-output%3Dhtml++-fill++";
    }

    public String getTrackingUrl(Test test) {
        return (BuildReportExtendedPlugin.createDiffUrl() + "&custom-part=-track%3D" + test.getName() + "++" + this.getJob() + "++0+-365").replaceAll("#", "%23");
    }
}

