/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.jtreg;

import io.jenkins.plugins.report.jtreg.model.BuildReport;
import io.jenkins.plugins.report.jtreg.model.Suite;
import io.jenkins.plugins.report.jtreg.model.SuiteTestChanges;
import io.jenkins.plugins.report.jtreg.model.SuitesWithResults;
import java.util.List;

public class BuildReportExtended
extends BuildReport {
    private final List<String> addedSuites;
    private final List<String> removedSuites;
    private final List<SuiteTestChanges> testChanges;
    private final int total;
    private final int notRun;
    private final SuitesWithResults allTests;
    private final String job;

    public BuildReportExtended(int buildNumber, String buildName, int passed, int failed, int error, List<Suite> suites, List<String> addedSuites, List<String> removedSuites, List<SuiteTestChanges> testChanges, int total, int notRun, SuitesWithResults allTests, String job) {
        super(buildNumber, buildName, passed, failed, error, suites, total, notRun);
        this.job = job;
        this.addedSuites = addedSuites;
        this.removedSuites = removedSuites;
        this.testChanges = testChanges;
        this.total = total;
        this.notRun = notRun;
        this.allTests = allTests;
    }

    public String getPreviousLink() {
        return "../../" + (this.getBuildNumber() - 1) + "/java-reports";
    }

    public String getPreviousLinkName() {
        return " << " + (this.getBuildNumber() - 1) + " << ";
    }

    public String getNextLink() {
        return "../../" + (this.getBuildNumber() + 1) + "/java-reports";
    }

    public String getNextLinkName() {
        return " >> " + (this.getBuildNumber() + 1) + " >> ";
    }

    public List<String> getAddedSuites() {
        return this.addedSuites;
    }

    public List<String> getRemovedSuites() {
        return this.removedSuites;
    }

    public List<SuiteTestChanges> getTestChanges() {
        return this.testChanges;
    }

    public String getJob() {
        return this.job;
    }

    @Override
    public int getTotal() {
        return this.total;
    }

    @Override
    public int getNotRun() {
        return this.notRun;
    }

    public SuitesWithResults getAllTests() {
        return this.allTests;
    }
}

