/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.jtreg;

import com.google.gson.GsonBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import io.jenkins.plugins.report.jtreg.ReportAction;
import io.jenkins.plugins.report.jtreg.ReportParserCallable;
import io.jenkins.plugins.report.jtreg.ReportProjectAction;
import io.jenkins.plugins.report.jtreg.model.BuildReportPlugin;
import io.jenkins.plugins.report.jtreg.model.Report;
import io.jenkins.plugins.report.jtreg.model.ReportFull;
import io.jenkins.plugins.report.jtreg.model.Suite;
import io.jenkins.plugins.report.jtreg.model.SuiteTests;
import io.jenkins.plugins.report.jtreg.parsers.ReportParser;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class AbstractReportPublisher
extends Recorder {
    private String reportFileGlob;
    private String resultsDenyList;
    private String resultsAllowList;
    private String maxBuilds;
    private int rangeAroundAlist;

    public AbstractReportPublisher(String reportFileGlob) {
        this.reportFileGlob = reportFileGlob;
    }

    protected abstract String defaultReportFileGlob();

    protected abstract ReportParser createReportParser();

    protected abstract String prefix();

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE", "RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification=" npe of spotbugs sucks")
    public final boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        List report;
        Object reportFileGlob = this.getReportFileGlob();
        if (reportFileGlob == null || ((String)reportFileGlob).trim().isEmpty()) {
            reportFileGlob = this.defaultReportFileGlob();
        }
        if (!((String)reportFileGlob).startsWith("glob:")) {
            reportFileGlob = "glob:" + (String)reportFileGlob;
        }
        if ((report = (List)build.getWorkspace().act((FilePath.FileCallable)new ReportParserCallable((String)reportFileGlob, this.createReportParser()))).stream().anyMatch(s -> s.getReport() != null && (s.getReport().getTestsError() != 0 || s.getReport().getTestsFailed() != 0))) {
            build.setResult(Result.UNSTABLE);
        }
        if (report.stream().anyMatch(s -> s.getReport() != null && (s.getReport().getTestsTotal() <= 0 || s.getReport().getTestsTotal() == s.getReport().getTestsNotRun()))) {
            build.setResult(Result.FAILURE);
        }
        this.storeFailuresSummary(report, new File(build.getRootDir(), this.prefix() + "-report.json"));
        this.storeFullTestsList(report, new File(build.getRootDir(), this.prefix() + "-tests-list.json"));
        this.addReportAction(build);
        return true;
    }

    private void addReportAction(AbstractBuild<?, ?> build) {
        ReportAction action = (ReportAction)build.getAction(ReportAction.class);
        if (action == null) {
            action = new ReportAction(build);
            action.addPrefix(this.prefix());
            build.addAction((Action)action);
        } else {
            action.addPrefix(this.prefix());
        }
    }

    void storeFailuresSummary(List<Suite> reportFull, File jsonFile) throws IOException {
        List<Suite> reportShort = ((Stream)reportFull.stream().sequential()).map(s -> new Suite(s.getName(), new Report(s.getReport().getTestsPassed(), s.getReport().getTestsNotRun(), s.getReport().getTestsFailed(), s.getReport().getTestsError(), s.getReport().getTestsTotal(), s.getReport().getTestProblems()))).sorted().collect(Collectors.toList());
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(jsonFile)), StandardCharsets.UTF_8);){
            new GsonBuilder().setPrettyPrinting().create().toJson(reportShort, (Appendable)out);
        }
        this.cacheReport(reportShort, jsonFile);
    }

    private void cacheReport(List<Suite> reportShort, File jsonFile) {
        try {
            int passedSumm = 0;
            int notRunSumm = 0;
            int failedSumm = 0;
            int errorSumm = 0;
            int totalSumm = 0;
            StringBuilder nameb = new StringBuilder();
            for (Suite s : reportShort) {
                passedSumm += s.getReport().getTestsPassed();
                notRunSumm += s.getReport().getTestsNotRun();
                failedSumm += s.getReport().getTestsFailed();
                errorSumm += s.getReport().getTestsError();
                totalSumm += s.getReport().getTestsTotal();
                nameb.append(s.getName()).append(" ");
            }
            File buildDir = jsonFile.getParentFile();
            int buildNumber = Integer.parseInt(buildDir.getName());
            BuildReportPlugin br = new BuildReportPlugin(buildNumber, nameb.toString().trim(), passedSumm, failedSumm, errorSumm, reportShort, totalSumm, notRunSumm);
            ReportProjectAction.cacheSumms(buildDir.getParentFile().getParentFile(), Arrays.asList(br));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void storeFullTestsList(List<Suite> reportFull, File jsonFile) throws IOException {
        List suites = ((Stream)reportFull.stream().sequential()).map(s -> new SuiteTests(s.getName(), s.getReport() instanceof ReportFull ? ((ReportFull)s.getReport()).getTestsList() : null)).sorted().collect(Collectors.toList());
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(jsonFile)), StandardCharsets.UTF_8);){
            new GsonBuilder().create().toJson(suites, (Appendable)out);
        }
    }

    public final BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @DataBoundSetter
    public void setReportFileGlob(String reportFileGlob) {
        this.reportFileGlob = reportFileGlob;
    }

    public String getReportFileGlob() {
        return this.reportFileGlob;
    }

    @DataBoundSetter
    public void setResultsDenyList(String resultsDenyList) {
        this.resultsDenyList = resultsDenyList;
    }

    public String getResultsDenyList() {
        return this.resultsDenyList;
    }

    @DataBoundSetter
    public void setMaxBuilds(String maxBuilds) {
        this.maxBuilds = maxBuilds;
    }

    public String getMaxBuilds() {
        if (this.maxBuilds == null) {
            return "10";
        }
        return this.maxBuilds;
    }

    public int getIntMaxBuilds() {
        try {
            return Integer.parseInt(this.getMaxBuilds().trim());
        }
        catch (NumberFormatException ex) {
            return 10;
        }
    }

    public String getResultsAllowList() {
        return this.resultsAllowList;
    }

    @DataBoundSetter
    public void setResultsAllowList(String resultsAllowList) {
        this.resultsAllowList = resultsAllowList;
    }

    public int getRangeAroundAlist() {
        return this.rangeAroundAlist;
    }

    @DataBoundSetter
    public void setRangeAroundAlist(int rangeAroundAlist) {
        this.rangeAroundAlist = rangeAroundAlist;
    }
}

