/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.genericdiff;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Describable;
import hudson.model.Job;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import io.jenkins.plugins.report.genericdiff.RpmsReport;
import io.jenkins.plugins.report.genericdiff.RpmsReportProjectAction;
import io.jenkins.plugins.report.genericdiff.RpmsReportPublisher;
import java.util.Collection;
import java.util.Collections;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.StaplerProxy;

public class RpmsReportAction
implements Action,
StaplerProxy,
SimpleBuildStep.LastBuildAction {
    private final AbstractBuild<?, ?> build;

    public RpmsReportAction(AbstractBuild<?, ?> build) {
        this.build = build;
    }

    private RpmsReportPublisher getPublisher() {
        DescribableList l = this.build.getProject().getPublishersList();
        for (Publisher p : (Publisher[])l.toArray((Describable[])new Publisher[0])) {
            if (!(p instanceof RpmsReportPublisher)) continue;
            return (RpmsReportPublisher)p;
        }
        return null;
    }

    public String getIconFileName() {
        return "clipboard.png";
    }

    public String getDisplayName() {
        return "Diff chart report";
    }

    public String getUrlName() {
        return "rpms";
    }

    public String getDiffUrlName() {
        String thisId = "0";
        String prevId = "0";
        if (this.build != null) {
            thisId = this.build.getId();
            AbstractBuild bb = (AbstractBuild)this.build.getPreviousNotFailedBuild();
            if (bb != null) {
                prevId = bb.getId();
            }
        }
        return "patch/dynamic-diff?from=" + thisId + "&to=" + prevId + "&ids=.*&context=-1";
    }

    public RpmsReport getTarget() {
        return new RpmsReport(this.getPublisher(), this.build);
    }

    public Collection<? extends Action> getProjectActions() {
        Job job = this.build.getParent();
        return Collections.singleton(new RpmsReportProjectAction(job));
    }
}

