/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.genericdiff;

import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.patch.Patch;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import io.jenkins.plugins.report.genericdiff.RpmsReport;
import io.jenkins.plugins.report.genericdiff.RpmsReportOneRecord;
import io.jenkins.plugins.report.genericdiff.RpmsReportPublisher;
import io.jenkins.plugins.report.genericdiff.RpmsReportSingle;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.verb.GET;

public class DiffReportAction
implements SimpleBuildStep.LastBuildAction {
    private final AbstractBuild<?, ?> build;

    public DiffReportAction(AbstractBuild<?, ?> build) {
        this.build = build;
    }

    private RpmsReportPublisher getRpmsReport(AbstractBuild<?, ?> build) {
        Optional<RpmsReportPublisher> publisher = build.getProject().getPublishersList().stream().filter(p -> p instanceof RpmsReportPublisher).map(a -> (RpmsReportPublisher)((Object)a)).findFirst();
        RpmsReportPublisher data = publisher.isPresent() ? publisher.get() : null;
        return data;
    }

    public String getDisplayName() {
        return "Patch like report";
    }

    @GET
    @WebMethod(name={"dynamic-diff"})
    public void doSearchOffset(StaplerRequest req, StaplerResponse res) throws IOException {
        long from;
        String sContext;
        res.setContentType("text/plain");
        res.setCharacterEncoding("UTF-8");
        PrintWriter out = res.getWriter();
        String[] interesting = req.getParameterValues("ids");
        if (interesting == null || interesting.length == 0 || interesting[0].isEmpty()) {
            interesting = new String[]{".*"};
        }
        if ((sContext = req.getParameter("context")) == null || sContext.isEmpty()) {
            sContext = "-1";
        }
        long context = -1L;
        try {
            context = Long.parseLong(sContext);
        }
        catch (NumberFormatException e) {
            context = -1L;
        }
        String sFrom = req.getParameter("from");
        String sTo = req.getParameter("to");
        if (sFrom == null || sTo == null || sFrom.isEmpty() || sTo.isEmpty()) {
            res.setStatus(404);
            out.print("expected from and to arguments at least");
            out.flush();
            return;
        }
        try {
            from = Long.parseLong(sFrom);
            long l = Long.parseLong(sTo);
        }
        catch (NumberFormatException e) {
            res.setStatus(404);
            out.print("from and to are supposed to be numbers");
            out.flush();
            return;
        }
        from = Long.parseLong(sFrom);
        long to = Long.parseLong(sTo);
        if (from <= 0L || to <= 0L) {
            res.setStatus(404);
            out.print("from and to have to be positive");
        } else {
            AbstractBuild bFrom = this.build.getProject().getBuild("" + from);
            AbstractBuild bTo = this.build.getProject().getBuild("" + to);
            RpmsReportPublisher pFrom = this.getRpmsReport(bFrom);
            RpmsReportPublisher pTo = this.getRpmsReport(bTo);
            if (pFrom == null && pTo == null) {
                res.setStatus(404);
                out.print("builds " + from + " nor " + to + " have RpmsReportPublisher");
            } else if (pFrom == null) {
                res.setStatus(404);
                out.print("build " + from + " do not have have RpmsReportPublisher");
            } else if (pTo == null) {
                res.setStatus(404);
                out.print("build " + to + " do not have have RpmsReportPublisher");
            } else {
                RpmsReport dataFrom = new RpmsReport(pFrom, bFrom);
                RpmsReport dataTo = new RpmsReport(pTo, bTo);
                List<String> resultLines = this.comapre(bFrom.getId(), bTo.getId(), dataFrom, dataTo, interesting, context);
                for (String resultLine : resultLines) {
                    out.println(resultLine);
                }
            }
        }
        out.flush();
    }

    private List<String> comapre(String id1, String id2, RpmsReport data1, RpmsReport data2, String[] interesting, long contex) {
        List<RpmsReportSingle> files1 = data1.getIndex();
        List<RpmsReportSingle> files2 = data2.getIndex();
        HashSet idsu = new HashSet();
        idsu.addAll(files1.stream().map(r -> r.getPublisher().getId()).collect(Collectors.toList()));
        idsu.addAll(files2.stream().map(r -> r.getPublisher().getId()).collect(Collectors.toList()));
        ArrayList ids = new ArrayList(idsu);
        Collections.sort(ids);
        ArrayList<String> resultLines = new ArrayList<String>();
        for (String id : ids) {
            List unifiedDiff;
            boolean wished = false;
            for (String s : interesting) {
                if (!id.matches(s)) continue;
                wished = true;
                break;
            }
            if (!wished) continue;
            List<Object> thisComaprsion1 = new ArrayList(0);
            List<Object> thisComaprsion2 = new ArrayList(0);
            for (RpmsReportSingle report : files1) {
                if (!report.getPublisher().getId().equals(id) || report.getAllRpms() == null) continue;
                thisComaprsion1 = report.getAllRpms();
            }
            for (RpmsReportSingle report : files2) {
                if (!report.getPublisher().getId().equals(id) || report.getAllRpms() == null) continue;
                thisComaprsion2 = report.getAllRpms();
            }
            Patch diff = DiffUtils.diff(thisComaprsion2, thisComaprsion1);
            int usedContext = (int)contex;
            if (contex < 0L) {
                usedContext = Math.max(thisComaprsion2.size(), thisComaprsion1.size());
            }
            if ((unifiedDiff = UnifiedDiffUtils.generateUnifiedDiff((String)(id2 + "/" + id), (String)(id1 + "/" + id), thisComaprsion2, (Patch)diff, (int)usedContext)).isEmpty()) {
                resultLines.add("--- " + id2 + "/" + id);
                resultLines.add("+++ " + id1 + "/" + id);
                resultLines.add("@@ " + id2 + "/" + id + " and " + id1 + "/" + id + " are identical @@");
                if (contex < 0L) {
                    resultLines.addAll(thisComaprsion1);
                    continue;
                }
                resultLines.add(" ");
                continue;
            }
            resultLines.addAll(unifiedDiff);
        }
        return resultLines;
    }

    public Collection<? extends Action> getProjectActions() {
        ArrayList list = new ArrayList();
        return list;
    }

    public String getIconFileName() {
        return "clipboard.png";
    }

    public String getUrlName() {
        return "patch";
    }

    public String getThisBuild() {
        if (this.build == null) {
            return "0";
        }
        return this.build.getId();
    }

    public String getPreviousBuild() {
        if (this.build == null) {
            return "0";
        }
        AbstractBuild previouSbuild = (AbstractBuild)this.build.getPreviousNotFailedBuild();
        if (previouSbuild == null) {
            return "0";
        }
        return previouSbuild.getId();
    }

    public List<String> getDiffIds() {
        if (this.build == null) {
            return Arrays.asList(".*");
        }
        RpmsReportPublisher pFrom = this.getRpmsReport(this.build);
        if (pFrom == null) {
            return Arrays.asList(".*");
        }
        ArrayList<String> r = new ArrayList<String>();
        for (RpmsReportOneRecord on : pFrom.getConfigurations()) {
            r.add(on.getId());
        }
        return r;
    }
}

