/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.remote.result.trigger;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.Run;
import io.jenkins.plugins.remote.result.trigger.RemoteBuildResultTriggerScheduledAction;
import io.jenkins.plugins.remote.result.trigger.model.JobResultInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class ReadRemoteJobsStep
extends Step {
    @DataBoundConstructor
    public ReadRemoteJobsStep() {
    }

    public StepExecution start(StepContext context) throws Exception {
        return new ReadRemoteJobsStepExecution(context);
    }

    public static class ReadRemoteJobsStepExecution
    extends SynchronousNonBlockingStepExecution<List<Map<?, ?>>> {
        private static final long serialVersionUID = 4436899316471397907L;

        public ReadRemoteJobsStepExecution(@NonNull StepContext context) {
            super(context);
        }

        protected List<Map<?, ?>> run() throws Exception {
            RemoteBuildResultTriggerScheduledAction action = this.getTriggerAction();
            ArrayList results = new ArrayList();
            if (action != null && !action.getJobResultInfos().isEmpty()) {
                for (JobResultInfo info : action.getJobResultInfos()) {
                    results.add(Map.of("uid", info.getUid(), "jobUrl", info.getRemoteJobUrl()));
                }
            }
            return results;
        }

        @Nullable
        private RemoteBuildResultTriggerScheduledAction getTriggerAction() throws IOException, InterruptedException {
            Run run = (Run)this.getContext().get(Run.class);
            if (run != null) {
                return (RemoteBuildResultTriggerScheduledAction)run.getAction(RemoteBuildResultTriggerScheduledAction.class);
            }
            return null;
        }
    }

    @Extension
    public static class ReadRemoteJobsStepDescriptor
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(Run.class);
        }

        public String getFunctionName() {
            return "readRemoteJobs";
        }
    }
}

