/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.actions;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import io.jenkins.plugins.actions.Config;
import io.jenkins.plugins.actions.TemplateScanBuilder;
import io.jenkins.plugins.commons.JenkinsUtil;
import io.jenkins.plugins.commons.model.Util;
import io.jenkins.plugins.jenkins.dto.QualysApiConfiguration;
import io.jenkins.plugins.validation.UIJenkinsValidation;
import io.jenkins.plugins.validation.UIValidation;
import java.io.File;
import java.time.Instant;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class TemplateScanBuildStep
extends Step {
    private String IaCServiceEndpoint;
    private String scanName;
    private String scanDirectories;
    private boolean isFailedResultsOnly;
    private boolean buildFailureSettings;
    private String high;
    private String medium;
    private String low;
    private boolean timeoutSettings;
    private String scanResultInterval;
    private String totalJobCompletionTime;
    private String jobName;
    private static final String DEFAULT_WORKSPACE_DIR = Jenkins.get().getRootDir().getPath() + File.separator + "workspace";
    private final Util util = Util.getInstance();
    private final UIValidation uIValidation = new UIJenkinsValidation();

    @DataBoundConstructor
    public TemplateScanBuildStep(String IaCServiceEndpoint, String scanName, String scanDirectories, boolean isFailedResultsOnly, boolean buildFailureSettings, String high, String medium, String low, boolean timeoutSettings, String scanResultInterval, String totalJobCompletionTime, String jobName) {
        this.IaCServiceEndpoint = IaCServiceEndpoint;
        this.scanName = this.uIValidation.validateScanName(scanName).isValid() ? scanName : "";
        this.scanDirectories = this.uIValidation.validateFolderPaths(scanDirectories, Jenkins.get().getRootDir().getPath() + File.separator + "workspace" + File.separator + jobName).isValid() ? scanDirectories.replaceAll("\\.{2,}", "").replaceAll("[\\/]+", "/").replaceAll("[\\\\]+", "\\\\") : "";
        this.isFailedResultsOnly = isFailedResultsOnly;
        this.buildFailureSettings = buildFailureSettings;
        this.high = this.uIValidation.validateNumber(high, 0, Integer.MAX_VALUE).isValid() ? high : "0";
        this.medium = this.uIValidation.validateNumber(medium, 0, Integer.MAX_VALUE).isValid() ? medium : "0";
        this.low = this.uIValidation.validateNumber(low, 0, Integer.MAX_VALUE).isValid() ? low : "0";
        this.timeoutSettings = timeoutSettings;
        this.scanResultInterval = this.uIValidation.validateNumber(scanResultInterval, 10, Integer.MAX_VALUE).isValid() ? scanResultInterval : "30";
        this.totalJobCompletionTime = this.uIValidation.validateNumber(totalJobCompletionTime, 10, Integer.MAX_VALUE).isValid() ? totalJobCompletionTime : "10";
        this.jobName = jobName;
    }

    public TemplateScanBuildStep() {
    }

    public void setIsFailedResultsOnly(boolean isFailedResultsOnly) {
        this.isFailedResultsOnly = isFailedResultsOnly;
    }

    public boolean getIsFailedResultsOnly() {
        return this.isFailedResultsOnly;
    }

    public String getFormattedScanName() {
        if (StringUtils.isEmpty((CharSequence)this.scanName.trim())) {
            return "jenkins_" + this.getSelectedIaCServiceEndpoint().getQualysUserName() + "_" + Instant.now().getEpochSecond();
        }
        return this.scanName;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public QualysApiConfiguration getSelectedIaCServiceEndpoint() {
        QualysApiConfiguration[] qualysApiConfigurations = this.getDescriptor().getIaCServiceEndpoints();
        if (qualysApiConfigurations != null && qualysApiConfigurations.length > 0) {
            for (QualysApiConfiguration qac : qualysApiConfigurations) {
                if (this.getIaCServiceEndpoint() == null || !this.getIaCServiceEndpoint().equals(qac.getName())) continue;
                return qac;
            }
            return qualysApiConfigurations[0];
        }
        return null;
    }

    public StepExecution start(StepContext sc) throws Exception {
        TemplateScanBuilder templateScanBuilder = new TemplateScanBuilder(this.getIaCServiceEndpoint(), this.getScanName(), this.getScanDirectories(), this.getIsFailedResultsOnly(), this.isBuildFailureSettings(), this.getHigh(), this.getMedium(), this.getLow(), this.isTimeoutSettings(), this.getScanResultInterval(), this.getTotalJobCompletionTime(), this.getJobName());
        return new IaCScanBuildExecution(sc, templateScanBuilder);
    }

    public void setIaCServiceEndpoint(String IaCServiceEndpoint) {
        this.IaCServiceEndpoint = IaCServiceEndpoint;
    }

    public String getIaCServiceEndpoint() {
        return this.IaCServiceEndpoint;
    }

    public void setScanName(String scanName) {
        this.scanName = scanName;
    }

    public String getScanName() {
        return this.scanName;
    }

    public void setScanDirectories(String scanDirectories) {
        this.scanDirectories = scanDirectories;
    }

    public String getScanDirectories() {
        return this.scanDirectories;
    }

    public void setBuildFailureSettings(boolean buildFailureSettings) {
        this.buildFailureSettings = buildFailureSettings;
    }

    public boolean isBuildFailureSettings() {
        return this.buildFailureSettings;
    }

    public void setHigh(String high) {
        this.high = high;
    }

    public String getHigh() {
        return this.high;
    }

    public void setMedium(String medium) {
        this.medium = medium;
    }

    public String getMedium() {
        return this.medium;
    }

    public void setLow(String low) {
        this.low = low;
    }

    public String getLow() {
        return this.low;
    }

    public void setTimeoutSettings(boolean timeoutSettings) {
        this.timeoutSettings = timeoutSettings;
    }

    public boolean isTimeoutSettings() {
        return this.timeoutSettings;
    }

    public void setScanResultInterval(String scanResultInterval) {
        this.scanResultInterval = scanResultInterval;
    }

    public String getScanResultInterval() {
        return this.scanResultInterval;
    }

    public void setTotalJobCompletionTime(String totalJobCompletionTime) {
        this.totalJobCompletionTime = totalJobCompletionTime;
    }

    public String getTotalJobCompletionTime() {
        return this.totalJobCompletionTime;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        private final UIValidation uIValidation = new UIJenkinsValidation();

        public String getDisplayName() {
            return "Qualys IaC Scan";
        }

        public QualysApiConfiguration[] getIaCServiceEndpoints() {
            Config config;
            if (GlobalConfiguration.all() != null && (config = (Config)((Object)GlobalConfiguration.all().get(Config.class))) != null) {
                return config.getQualysApiConfigurations();
            }
            QualysApiConfiguration[] qualysApiConfigurations = new QualysApiConfiguration[1];
            return qualysApiConfigurations;
        }

        public FormValidation doCheckIaCServiceEndpoint(@QueryParameter String IaCServiceEndpoint, @QueryParameter String isPageLoad) {
            return JenkinsUtil.showErrorIfExists(this.uIValidation.validateIaCServiceEndpoint(IaCServiceEndpoint, "-1"), isPageLoad);
        }

        public FormValidation doCheckScanName(@QueryParameter String scanName, @QueryParameter String isPageLoad) {
            return JenkinsUtil.showErrorIfExists(this.uIValidation.validateScanName(scanName), isPageLoad);
        }

        public FormValidation doCheckScanDirectories(@AncestorInPath Job job, @QueryParameter String isPageLoad, @QueryParameter String scanDirectories) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return JenkinsUtil.showErrorIfExists(this.uIValidation.validateFolderPaths(scanDirectories, Jenkins.get().getRootDir().getPath() + File.separator + "workspace" + File.separator + job.getDisplayName()), isPageLoad);
        }

        public FormValidation doCheckHigh(@QueryParameter String high, @QueryParameter String isPageLoad) {
            return JenkinsUtil.showErrorIfExists(this.uIValidation.validateNumber(high, 0, Integer.MAX_VALUE), isPageLoad);
        }

        public FormValidation doCheckMedium(@QueryParameter String medium, @QueryParameter String isPageLoad) {
            return JenkinsUtil.showErrorIfExists(this.uIValidation.validateNumber(medium, 0, Integer.MAX_VALUE), isPageLoad);
        }

        public FormValidation doCheckLow(@QueryParameter String low, @QueryParameter String isPageLoad) {
            return JenkinsUtil.showErrorIfExists(this.uIValidation.validateNumber(low, 0, Integer.MAX_VALUE), isPageLoad);
        }

        public FormValidation doCheckScanResultInterval(@QueryParameter String scanResultInterval, @QueryParameter String isPageLoad) {
            return JenkinsUtil.showErrorIfExists(this.uIValidation.validateNumber(scanResultInterval, 10, Integer.MAX_VALUE), isPageLoad);
        }

        public FormValidation doCheckTotalJobCompletionTime(@QueryParameter String totalJobCompletionTime, @QueryParameter String isPageLoad) {
            return JenkinsUtil.showErrorIfExists(this.uIValidation.validateNumber(totalJobCompletionTime, 10, Integer.MAX_VALUE), isPageLoad);
        }

        public String getFunctionName() {
            return "qualysIaCScan";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(Run.class);
        }
    }

    public static final class IaCScanBuildExecution
    extends StepExecution {
        private static final long serialVersionUID = 1L;
        private final transient TemplateScanBuilder templateScanBuilder;

        private IaCScanBuildExecution(StepContext sc, TemplateScanBuilder templateScanBuilder) {
            super(sc);
            this.templateScanBuilder = templateScanBuilder;
        }

        public boolean start() throws Exception {
            StepContext stepContext = this.getContext();
            this.templateScanBuilder.perform((Run)stepContext.get(Run.class), (FilePath)stepContext.get(FilePath.class), (EnvVars)stepContext.get(EnvVars.class), (Launcher)stepContext.get(Launcher.class), (TaskListener)stepContext.get(TaskListener.class));
            this.getContext().onSuccess((Object)true);
            return true;
        }

        public void stop(@Nonnull Throwable cause) throws Exception {
            this.getContext().onFailure(cause);
        }
    }
}

