/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.portshift_vulnerability_scanner;

import hudson.AbortException;
import hudson.BulkChange;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.Secret;
import io.jenkins.plugins.portshift_vulnerability_scanner.Messages;
import io.jenkins.plugins.portshift_vulnerability_scanner.PortshiftVulnerabilityScanExecuter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.UUID;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class PortshiftVulnerabilityScannerBuilder
extends Builder
implements SimpleBuildStep {
    protected static final String PLUGIN_NAME = "portshift-ci";
    private static final String IMAGE_NAME_REGEX = "^[a-z0-9]([-a-z0-9]*[a-z0-9])?$";
    private static final String IMAGE_TAG_REGEX = "\\S+";
    private String accessKey;
    private Secret secretKey;
    private String imageName;
    private String imageTag;
    private String url;
    private String scannerIp;

    @DataBoundConstructor
    public PortshiftVulnerabilityScannerBuilder(String accessKey, String secretKey, String imageName, String imageTag, String url, String scannerIp) {
        this.accessKey = accessKey;
        this.secretKey = Secret.fromString((String)secretKey);
        this.imageName = imageName;
        this.imageTag = imageTag;
        this.scannerIp = scannerIp;
        this.url = url.contains("://") ? url.split("://")[1] : url;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws AbortException {
        if (this.accessKey == null || this.secretKey == null || this.imageName == null || this.imageTag == null || this.url == null || this.scannerIp == null) {
            throw new AbortException("Missing configuration. Please set the plugin configuration parameters before continuing.\n");
        }
        int exitCode = PortshiftVulnerabilityScanExecuter.execute(run, workspace, launcher, listener, this.accessKey, this.secretKey, this.imageName, this.imageTag, this.url, this.scannerIp);
        listener.getLogger().println("exitCode: " + exitCode);
        String failedMessage = "Vulnerability scan has failed.";
        switch (exitCode) {
            case 0: {
                listener.getLogger().println("Vulnerability scan has completed successfully.");
                break;
            }
            case 4: {
                throw new AbortException(failedMessage);
            }
            default: {
                throw new AbortException(failedMessage);
            }
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Symbol(value={"portshift_vulnerability_scanner"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private static final String IP_PATTERN = "^((0|1\\d?\\d?|2[0-4]?\\d?|25[0-5]?|[3-9]\\d?)\\.){3}(0|1\\d?\\d?|2[0-4]?\\d?|25[0-5]?|[3-9]\\d?)$";
        public static final String LATEST_TAG = "latest";
        private String accessKey;
        private Secret secretKey;
        private String imageName;
        private String imageTag;
        private String url;
        private String scannerIp;

        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckAccessKey(@QueryParameter String accessKey) {
            try {
                UUID.fromString(accessKey);
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)Messages.PortshiftVulnerabilityScannerBuilder_DescriptorImpl_errors_invalidAccesskey());
            }
        }

        public FormValidation doCheckSecretKey(@QueryParameter String secretKey) {
            try {
                Base64.Decoder decoder = Base64.getDecoder();
                decoder.decode(secretKey);
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)Messages.PortshiftVulnerabilityScannerBuilder_DescriptorImpl_errors_invalidSecretkey());
            }
        }

        public FormValidation doCheckImageName(@QueryParameter String imageName) {
            try {
                if (!imageName.matches(PortshiftVulnerabilityScannerBuilder.IMAGE_NAME_REGEX)) {
                    return FormValidation.error((String)Messages.PortshiftVulnerabilityScannerBuilder_DescriptorImpl_errors_invalidImageName());
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)Messages.PortshiftVulnerabilityScannerBuilder_DescriptorImpl_errors_invalidImageName());
            }
        }

        public FormValidation doCheckImageTag(@QueryParameter String imageTag) {
            try {
                if (!StringUtils.isEmpty((String)imageTag) && !imageTag.matches(PortshiftVulnerabilityScannerBuilder.IMAGE_TAG_REGEX)) {
                    return FormValidation.error((String)Messages.PortshiftVulnerabilityScannerBuilder_DescriptorImpl_errors_invalidImageTag());
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)Messages.PortshiftVulnerabilityScannerBuilder_DescriptorImpl_errors_invalidImageTag());
            }
        }

        public FormValidation doCheckUrl(@QueryParameter String url) {
            try {
                if (!this.isValidUrl(url) && !this.isValidUrl("https://" + url)) {
                    return FormValidation.error((String)Messages.PortshiftVulnerabilityScannerBuilder_DescriptorImpl_errors_invalidUrl());
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)Messages.PortshiftVulnerabilityScannerBuilder_DescriptorImpl_errors_invalidUrl());
            }
        }

        public FormValidation doCheckScannerIp(@QueryParameter String scannerIp) {
            try {
                if (!DescriptorImpl.isValidIp(scannerIp)) {
                    return FormValidation.error((String)Messages.PortshiftVulnerabilityScannerBuilder_DescriptorImpl_errors_invalidScannerIp());
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)Messages.PortshiftVulnerabilityScannerBuilder_DescriptorImpl_errors_invalidScannerIp());
            }
        }

        private boolean isValidUrl(String url) {
            try {
                new URL(url);
                return true;
            }
            catch (MalformedURLException e) {
                return false;
            }
        }

        public static boolean isValidIp(String ip) {
            return ip.matches(IP_PATTERN);
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.PortshiftVulnerabilityScannerBuilder_DescriptorImpl_DisplayName();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            try (BulkChange bc = new BulkChange((Saveable)this);){
                req.bindJSON((Object)this, formData);
                bc.commit();
            }
            catch (IOException e) {
                throw new Descriptor.FormException((Throwable)e, "failed to parse form data");
            }
            return true;
        }

        @DataBoundSetter
        public DescriptorImpl setAccessKey(String accessKey) {
            this.accessKey = accessKey;
            this.save();
            return this;
        }

        @DataBoundSetter
        public DescriptorImpl setSecretKey(Secret secretKey) {
            this.secretKey = secretKey;
            this.save();
            return this;
        }

        @DataBoundSetter
        public DescriptorImpl setImageName(String imageName) {
            this.imageName = imageName;
            this.save();
            return this;
        }

        @DataBoundSetter
        public DescriptorImpl setUrl(String url) {
            this.url = url;
            this.save();
            return this;
        }

        @DataBoundSetter
        public DescriptorImpl setScannerIp(String scannerIp) {
            this.scannerIp = scannerIp;
            this.save();
            return this;
        }

        @DataBoundSetter
        public DescriptorImpl setImageTag(String imageTag) {
            if (StringUtils.isEmpty((String)imageTag)) {
                imageTag = LATEST_TAG;
            }
            this.imageTag = imageTag;
            return this;
        }
    }
}

