/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.portshift_vulnerability_scanner;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import hudson.util.Secret;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Objects;
import jenkins.model.Jenkins;

public class PortshiftVulnerabilityScanExecuter {
    private static final String EXEC_FILE_NAME = "portshift_deployment_cli";

    static int execute(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, String accessKey, Secret secretKey, String imageName, String imageTag, String url, String scannerIp) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int exitCode = PortshiftVulnerabilityScanExecuter.runExecutable(launcher, listener, accessKey, secretKey, imageName, imageTag, url, scannerIp, output);
            if (exitCode == 0) {
                listener.getLogger().println("Execution succeeded.");
            } else {
                listener.getLogger().println("Execution failed.");
            }
            File outputFile = new File(build.getRootDir(), imageName + "_" + imageTag + "_output");
            try (FileOutputStream outputFileOutputStream = new FileOutputStream(outputFile);){
                outputFileOutputStream.write(output.toByteArray());
            }
            FilePath latestTarget = new FilePath(workspace, "portshift_latest_scan.html");
            PortshiftVulnerabilityScanExecuter.writeHtml(listener, latestTarget, output, imageName, imageTag);
            return exitCode;
        }
        catch (Exception e) {
            listener.getLogger().println("Execution failed: " + e.getMessage());
            return 4;
        }
    }

    private static void writeHtml(TaskListener listener, FilePath latestTarget, ByteArrayOutputStream output, String imageName, String imageTag) throws IOException, InterruptedException {
        String html = "<!DOCTYPE HTML>\n<html lang=\"en\">\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/><title>\n" + imageName + ":" + imageTag + "</title>\n</head>\n<body>\n<h1>\n" + output + "</h1>\n</body>\n</html>\n\n";
        File file = new File(latestTarget.toURI());
        if (!file.createNewFile()) {
            listener.getLogger().println("Failed to create Portshift Vulnerability Scanner HTML report.");
        }
        try {
            Files.write(file.toPath(), Collections.singleton(html), new OpenOption[0]);
        }
        catch (Exception e) {
            listener.getLogger().println("Failed to save Portshift Vulnerability Scanner HTML report.");
        }
    }

    private static int runExecutable(Launcher launcher, TaskListener listener, String accessKey, Secret secretKey, String imageName, String imageTag, String url, String scannerIp, ByteArrayOutputStream output) throws IOException, InterruptedException, URISyntaxException {
        String webappPath = Objects.requireNonNull(Jenkins.get().getPlugin((String)"portshift-ci")).getWrapper().baseResourceURL.toURI().getPath();
        Launcher.ProcStarter ps = launcher.launch();
        ArgumentListBuilder args = new ArgumentListBuilder();
        String filePath = webappPath + EXEC_FILE_NAME;
        Runtime.getRuntime().exec("chmod +x " + filePath);
        String executeFileCommand = String.format("%s run-vulnerability-scan --access-key %s --secret-key %s --image-name %s --image-tag %s --url %s --scanner-ip %s", filePath, accessKey, secretKey, imageName, imageTag, url, scannerIp);
        args.add(new String[]{"bash", "-c", executeFileCommand});
        ps.cmds(args);
        ps.stdin(null);
        ps.stdout((OutputStream)output);
        ps.stderr((OutputStream)listener.getLogger());
        listener.getLogger().println("Vulnerability scan in progress...");
        return ps.join();
    }
}

