// CHECKSTYLE:OFF

package io.jenkins.plugins.portshift_vulnerability_scanner;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code
     * PortshiftVulnerabilityScannerBuilder.DescriptorImpl.errors.invalidScannerIp}:
     * {@code param 'Scanner IP' is invalid. Not a valid IP!}.
     * 
     * @return
     *     {@code param 'Scanner IP' is invalid. Not a valid IP!}
     */
    public static String PortshiftVulnerabilityScannerBuilder_DescriptorImpl_errors_invalidScannerIp() {
        return holder.format("PortshiftVulnerabilityScannerBuilder.DescriptorImpl.errors.invalidScannerIp");
    }

    /**
     * Key {@code
     * PortshiftVulnerabilityScannerBuilder.DescriptorImpl.errors.invalidScannerIp}:
     * {@code param 'Scanner IP' is invalid. Not a valid IP!}.
     * 
     * @return
     *     {@code param 'Scanner IP' is invalid. Not a valid IP!}
     */
    public static Localizable _PortshiftVulnerabilityScannerBuilder_DescriptorImpl_errors_invalidScannerIp() {
        return new Localizable(holder, "PortshiftVulnerabilityScannerBuilder.DescriptorImpl.errors.invalidScannerIp");
    }

    /**
     * Key {@code
     * PortshiftVulnerabilityScannerBuilder.DescriptorImpl.errors.invalidSecretkey}:
     * {@code param 'Secret Key' is invalid. Must be a base64 string!}.
     * 
     * @return
     *     {@code param 'Secret Key' is invalid. Must be a base64 string!}
     */
    public static String PortshiftVulnerabilityScannerBuilder_DescriptorImpl_errors_invalidSecretkey() {
        return holder.format("PortshiftVulnerabilityScannerBuilder.DescriptorImpl.errors.invalidSecretkey");
    }

    /**
     * Key {@code
     * PortshiftVulnerabilityScannerBuilder.DescriptorImpl.errors.invalidSecretkey}:
     * {@code param 'Secret Key' is invalid. Must be a base64 string!}.
     * 
     * @return
     *     {@code param 'Secret Key' is invalid. Must be a base64 string!}
     */
    public static Localizable _PortshiftVulnerabilityScannerBuilder_DescriptorImpl_errors_invalidSecretkey() {
        return new Localizable(holder, "PortshiftVulnerabilityScannerBuilder.DescriptorImpl.errors.invalidSecretkey");
    }

    /**
     * Key {@code
     * PortshiftVulnerabilityScannerBuilder.DescriptorImpl.errors.invalidUrl}:
     * {@code param 'Portshift Management URL' is invalid. Not a valid URL!}.
     * 
     * @return
     *     {@code param 'Portshift Management URL' is invalid. Not a valid URL!}
     */
    public static String PortshiftVulnerabilityScannerBuilder_DescriptorImpl_errors_invalidUrl() {
        return holder.format("PortshiftVulnerabilityScannerBuilder.DescriptorImpl.errors.invalidUrl");
    }

    /**
     * Key {@code
     * PortshiftVulnerabilityScannerBuilder.DescriptorImpl.errors.invalidUrl}:
     * {@code param 'Portshift Management URL' is invalid. Not a valid URL!}.
     * 
     * @return
     *     {@code param 'Portshift Management URL' is invalid. Not a valid URL!}
     */
    public static Localizable _PortshiftVulnerabilityScannerBuilder_DescriptorImpl_errors_invalidUrl() {
        return new Localizable(holder, "PortshiftVulnerabilityScannerBuilder.DescriptorImpl.errors.invalidUrl");
    }

    /**
     * Key {@code
     * PortshiftVulnerabilityScannerBuilder.DescriptorImpl.errors.invalidImageName}:
     * {@code param 'Image Name' is invalid. Doesn't match docker image name
     * constraints!}.
     * 
     * @return
     *     {@code param 'Image Name' is invalid. Doesn't match docker image name
     *     constraints!}
     */
    public static String PortshiftVulnerabilityScannerBuilder_DescriptorImpl_errors_invalidImageName() {
        return holder.format("PortshiftVulnerabilityScannerBuilder.DescriptorImpl.errors.invalidImageName");
    }

    /**
     * Key {@code
     * PortshiftVulnerabilityScannerBuilder.DescriptorImpl.errors.invalidImageName}:
     * {@code param 'Image Name' is invalid. Doesn't match docker image name
     * constraints!}.
     * 
     * @return
     *     {@code param 'Image Name' is invalid. Doesn't match docker image name
     *     constraints!}
     */
    public static Localizable _PortshiftVulnerabilityScannerBuilder_DescriptorImpl_errors_invalidImageName() {
        return new Localizable(holder, "PortshiftVulnerabilityScannerBuilder.DescriptorImpl.errors.invalidImageName");
    }

    /**
     * Key {@code
     * PortshiftVulnerabilityScannerBuilder.DescriptorImpl.errors.invalidAccesskey}:
     * {@code param 'Access Key' is invalid. Must be a UUID string!}.
     * 
     * @return
     *     {@code param 'Access Key' is invalid. Must be a UUID string!}
     */
    public static String PortshiftVulnerabilityScannerBuilder_DescriptorImpl_errors_invalidAccesskey() {
        return holder.format("PortshiftVulnerabilityScannerBuilder.DescriptorImpl.errors.invalidAccesskey");
    }

    /**
     * Key {@code
     * PortshiftVulnerabilityScannerBuilder.DescriptorImpl.errors.invalidAccesskey}:
     * {@code param 'Access Key' is invalid. Must be a UUID string!}.
     * 
     * @return
     *     {@code param 'Access Key' is invalid. Must be a UUID string!}
     */
    public static Localizable _PortshiftVulnerabilityScannerBuilder_DescriptorImpl_errors_invalidAccesskey() {
        return new Localizable(holder, "PortshiftVulnerabilityScannerBuilder.DescriptorImpl.errors.invalidAccesskey");
    }

    /**
     * Key {@code
     * PortshiftVulnerabilityScannerBuilder.DescriptorImpl.DisplayName}:
     * {@code Portshift Vulnerability Scanner}.
     * 
     * @return
     *     {@code Portshift Vulnerability Scanner}
     */
    public static String PortshiftVulnerabilityScannerBuilder_DescriptorImpl_DisplayName() {
        return holder.format("PortshiftVulnerabilityScannerBuilder.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code
     * PortshiftVulnerabilityScannerBuilder.DescriptorImpl.DisplayName}:
     * {@code Portshift Vulnerability Scanner}.
     * 
     * @return
     *     {@code Portshift Vulnerability Scanner}
     */
    public static Localizable _PortshiftVulnerabilityScannerBuilder_DescriptorImpl_DisplayName() {
        return new Localizable(holder, "PortshiftVulnerabilityScannerBuilder.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code
     * PortshiftVulnerabilityScannerBuilder.DescriptorImpl.errors.invalidImageTag}:
     * {@code param 'Image Tag' is invalid. Doesn't match docker image tag
     * constraints!}.
     * 
     * @return
     *     {@code param 'Image Tag' is invalid. Doesn't match docker image tag
     *     constraints!}
     */
    public static String PortshiftVulnerabilityScannerBuilder_DescriptorImpl_errors_invalidImageTag() {
        return holder.format("PortshiftVulnerabilityScannerBuilder.DescriptorImpl.errors.invalidImageTag");
    }

    /**
     * Key {@code
     * PortshiftVulnerabilityScannerBuilder.DescriptorImpl.errors.invalidImageTag}:
     * {@code param 'Image Tag' is invalid. Doesn't match docker image tag
     * constraints!}.
     * 
     * @return
     *     {@code param 'Image Tag' is invalid. Doesn't match docker image tag
     *     constraints!}
     */
    public static Localizable _PortshiftVulnerabilityScannerBuilder_DescriptorImpl_errors_invalidImageTag() {
        return new Localizable(holder, "PortshiftVulnerabilityScannerBuilder.DescriptorImpl.errors.invalidImageTag");
    }

}
