/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import hudson.model.Result;
import io.jenkins.plugins.util.QualityGateResult;
import java.util.Objects;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.CheckReturnValue;

public class QualityGateResultQualityGateItemApiAssert
extends AbstractObjectAssert<QualityGateResultQualityGateItemApiAssert, QualityGateResult.QualityGateItemApi> {
    public QualityGateResultQualityGateItemApiAssert(QualityGateResult.QualityGateItemApi actual) {
        super((Object)actual, QualityGateResultQualityGateItemApiAssert.class);
    }

    @CheckReturnValue
    public static QualityGateResultQualityGateItemApiAssert assertThat(QualityGateResult.QualityGateItemApi actual) {
        return new QualityGateResultQualityGateItemApiAssert(actual);
    }

    public QualityGateResultQualityGateItemApiAssert hasQualityGate(String qualityGate) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting qualityGate of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualQualityGate = ((QualityGateResult.QualityGateItemApi)this.actual).getQualityGate();
        if (!Objects.deepEquals(actualQualityGate, qualityGate)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, qualityGate, actualQualityGate});
        }
        return this;
    }

    public QualityGateResultQualityGateItemApiAssert hasResult(Result result) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting result of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Result actualResult = ((QualityGateResult.QualityGateItemApi)this.actual).getResult();
        if (!Objects.deepEquals(actualResult, result)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, result, actualResult});
        }
        return this;
    }

    public QualityGateResultQualityGateItemApiAssert hasThreshold(double threshold) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting threshold of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        double actualThreshold = ((QualityGateResult.QualityGateItemApi)this.actual).getThreshold();
        if (actualThreshold != threshold) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, threshold, actualThreshold});
        }
        return this;
    }

    public QualityGateResultQualityGateItemApiAssert hasThresholdCloseTo(double threshold, double assertjOffset) {
        this.isNotNull();
        double actualThreshold = ((QualityGateResult.QualityGateItemApi)this.actual).getThreshold();
        String assertjErrorMessage = String.format("\nExpecting threshold:\n  <%s>\nto be close to:\n  <%s>\nby less than <%s> but difference was <%s>", actualThreshold, threshold, assertjOffset, Math.abs(threshold - actualThreshold));
        ((AbstractDoubleAssert)Assertions.assertThat((double)actualThreshold).overridingErrorMessage(assertjErrorMessage, new Object[0])).isCloseTo(threshold, Assertions.within((Double)assertjOffset));
        return this;
    }

    public QualityGateResultQualityGateItemApiAssert hasValue(String value) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting value of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualValue = ((QualityGateResult.QualityGateItemApi)this.actual).getValue();
        if (!Objects.deepEquals(actualValue, value)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, value, actualValue});
        }
        return this;
    }
}

