/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.libs;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.AbstractFolderPropertyDescriptor;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.libs.LibraryConfiguration;
import org.jenkinsci.plugins.workflow.libs.LibraryResolver;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class FolderLibraries
extends AbstractFolderProperty<AbstractFolder<?>> {
    private final List<LibraryConfiguration> libraries;

    @DataBoundConstructor
    public FolderLibraries(List<LibraryConfiguration> libraries) {
        this.libraries = libraries;
    }

    public List<LibraryConfiguration> getLibraries() {
        return this.libraries;
    }

    @Extension(ordinal=100.0)
    public static class ForJob
    extends LibraryResolver {
        @Override
        public boolean isTrusted() {
            return false;
        }

        private Collection<LibraryConfiguration> forGroup(@CheckForNull ItemGroup<?> group, boolean checkPermission) {
            ArrayList<LibraryConfiguration> libraries = new ArrayList<LibraryConfiguration>();
            ItemGroup g = group;
            while (g instanceof AbstractFolder) {
                FolderLibraries prop;
                AbstractFolder f = (AbstractFolder)g;
                if ((!checkPermission || f.hasPermission(Item.CONFIGURE)) && (prop = (FolderLibraries)f.getProperties().get(FolderLibraries.class)) != null) {
                    String source = ForJob.class.getName() + " " + f.getFullName();
                    for (LibraryConfiguration library : prop.getLibraries()) {
                        libraries.add(new LibraryResolver.ResolvedLibraryConfiguration(library, source));
                    }
                }
                g = ((AbstractFolder)g).getParent();
            }
            return libraries;
        }

        @Override
        public Collection<LibraryConfiguration> forJob(Job<?, ?> job, Map<String, String> libraryVersions) {
            return this.forGroup(job.getParent(), false);
        }

        @Override
        public Collection<LibraryConfiguration> fromConfiguration(StaplerRequest2 request) {
            return this.forGroup((ItemGroup)request.findAncestorObject(AbstractFolder.class), true);
        }

        @Override
        public Collection<LibraryConfiguration> suggestedConfigurations(ItemGroup<?> group) {
            return this.forGroup(group, false);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractFolderPropertyDescriptor {
        public AbstractFolderProperty<?> newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            FolderLibraries prop = (FolderLibraries)super.newInstance(req, formData);
            return prop.libraries.isEmpty() ? null : prop;
        }
    }
}

