/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.cards.items;

import io.jenkins.plugins.pipelinegraphview.cards.RunDetailsItem;
import java.util.List;
import java.util.Optional;
import jenkins.scm.api.SCMRevisionAction;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import org.jenkinsci.plugins.github_branch_source.GitHubLink;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMHead;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMRevision;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class GitHubBranchSourceRunDetailsItems {
    public static String getGitCommit(SCMRevisionAction scmRevisionAction) {
        PullRequestSCMRevision revision = (PullRequestSCMRevision)scmRevisionAction.getRevision();
        return revision.getPullHash().substring(0, 7);
    }

    public static List<RunDetailsItem> getGitInformation(SCMRevisionAction scmRevisionAction) {
        PullRequestSCMRevision revision = (PullRequestSCMRevision)scmRevisionAction.getRevision();
        PullRequestSCMHead head = (PullRequestSCMHead)revision.getHead();
        String sourceOwner = head.getSourceOwner();
        String sourceRepo = head.getSourceRepo();
        String sourceBranch = head.getSourceBranch();
        RunDetailsItem.RunDetail gitRepositoryItem = new RunDetailsItem.RunDetail(new RunDetailsItem.Icon.Ionicon("logo-github"), RunDetailsItem.ItemContent.of(sourceOwner + "/" + sourceRepo));
        RunDetailsItem.RunDetail gitBranchItem = new RunDetailsItem.RunDetail(new RunDetailsItem.Icon.Ionicon("git-branch-outline"), RunDetailsItem.ItemContent.of(sourceBranch));
        return List.of(gitRepositoryItem, gitBranchItem);
    }

    public static Optional<RunDetailsItem> getGitHubLink(WorkflowRun run) {
        GitHubLink gitHubLink = (GitHubLink)((WorkflowJob)run.getParent()).getAction(GitHubLink.class);
        if (gitHubLink == null) {
            return Optional.empty();
        }
        ObjectMetadataAction action = (ObjectMetadataAction)((WorkflowJob)run.getParent()).getAction(ObjectMetadataAction.class);
        String name = action.getObjectDisplayName();
        if (name == null) {
            return Optional.empty();
        }
        return Optional.of(new RunDetailsItem.RunDetail(new RunDetailsItem.Icon.Ionicon("git-pull-request-outline"), RunDetailsItem.ItemContent.of(gitHubLink.getUrl(), name)));
    }
}

