// CHECKSTYLE:OFF

package io.jenkins.plugins.pipelinegraphview;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code startedAgo}: {@code Started {0} ago}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started {0} ago}
     */
    public static String startedAgo(Object arg0) {
        return holder.format("startedAgo", arg0);
    }

    /**
     * Key {@code startedAgo}: {@code Started {0} ago}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started {0} ago}
     */
    public static Localizable _startedAgo(Object arg0) {
        return new Localizable(holder, "startedAgo", arg0);
    }

    /**
     * Key {@code noBuilds}: {@code No builds}.
     * 
     * @return
     *     {@code No builds}
     */
    public static String noBuilds() {
        return holder.format("noBuilds");
    }

    /**
     * Key {@code noBuilds}: {@code No builds}.
     * 
     * @return
     *     {@code No builds}
     */
    public static Localizable _noBuilds() {
        return new Localizable(holder, "noBuilds");
    }

    /**
     * Key {@code Util.second}: {@code {0} sec}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} sec}
     */
    public static String Util_second(Object arg0) {
        return holder.format("Util.second", arg0);
    }

    /**
     * Key {@code Util.second}: {@code {0} sec}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} sec}
     */
    public static Localizable _Util_second(Object arg0) {
        return new Localizable(holder, "Util.second", arg0);
    }

    /**
     * Key {@code Util.month}: {@code {0} mo}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} mo}
     */
    public static String Util_month(Object arg0) {
        return holder.format("Util.month", arg0);
    }

    /**
     * Key {@code Util.month}: {@code {0} mo}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} mo}
     */
    public static Localizable _Util_month(Object arg0) {
        return new Localizable(holder, "Util.month", arg0);
    }

    /**
     * Key {@code Util.minute}: {@code {0} min}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} min}
     */
    public static String Util_minute(Object arg0) {
        return holder.format("Util.minute", arg0);
    }

    /**
     * Key {@code Util.minute}: {@code {0} min}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} min}
     */
    public static Localizable _Util_minute(Object arg0) {
        return new Localizable(holder, "Util.minute", arg0);
    }

    /**
     * Key {@code Util.year}: {@code {0} yr}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} yr}
     */
    public static String Util_year(Object arg0) {
        return holder.format("Util.year", arg0);
    }

    /**
     * Key {@code Util.year}: {@code {0} yr}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} yr}
     */
    public static Localizable _Util_year(Object arg0) {
        return new Localizable(holder, "Util.year", arg0);
    }

    /**
     * Key {@code Util.hour}: {@code {0} hr}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} hr}
     */
    public static String Util_hour(Object arg0) {
        return holder.format("Util.hour", arg0);
    }

    /**
     * Key {@code Util.hour}: {@code {0} hr}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} hr}
     */
    public static Localizable _Util_hour(Object arg0) {
        return new Localizable(holder, "Util.hour", arg0);
    }

    /**
     * Key {@code Util.day}: {@code {0} {0,choice,0#days|1#day|1<days}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code {0} {0,choice,0#days|1#day|1<days}}
     */
    public static String Util_day(Object arg0) {
        return holder.format("Util.day", arg0);
    }

    /**
     * Key {@code Util.day}: {@code {0} {0,choice,0#days|1#day|1<days}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code {0} {0,choice,0#days|1#day|1<days}}
     */
    public static Localizable _Util_day(Object arg0) {
        return new Localizable(holder, "Util.day", arg0);
    }

    /**
     * Key {@code Util.millisecond}: {@code {0} ms}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} ms}
     */
    public static String Util_millisecond(Object arg0) {
        return holder.format("Util.millisecond", arg0);
    }

    /**
     * Key {@code Util.millisecond}: {@code {0} ms}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} ms}
     */
    public static Localizable _Util_millisecond(Object arg0) {
        return new Localizable(holder, "Util.millisecond", arg0);
    }

}
