/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.openmfa.util;

import hudson.model.User;
import io.jenkins.plugins.openmfa.MFAGlobalConfiguration;
import io.jenkins.plugins.openmfa.MFAUserProperty;
import io.jenkins.plugins.openmfa.base.MFAException;
import io.jenkins.plugins.openmfa.util.JenkinsUtil;
import java.util.Optional;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.codec.binary.Base32;

public class TOTPUtil {
    public static String generateTOTP(String secret) {
        return TOTPUtil.generateTOTP(secret, System.currentTimeMillis() / 1000L / 30L);
    }

    public static String generateTOTP(String secret, long timeCounter) {
        Base32 base32 = new Base32();
        byte[] bytes = base32.decode(secret);
        String hexKey = TOTPUtil.bytesToHex(bytes);
        String hexTime = Long.toHexString(timeCounter);
        return TOTPUtil.generateTOTP(hexKey, hexTime, String.valueOf(6));
    }

    public static String getProvisioningUri(String username, String secret, String issuer) {
        return String.format("otpauth://totp/%s:%s?secret=%s&issuer=%s", issuer, username, secret.replace("=", ""), issuer);
    }

    public static boolean isMFAEnabled() {
        return JenkinsUtil.getCurrentUser().map(TOTPUtil::isMFAEnabled).orElse(false);
    }

    public static boolean isMFAEnabled(User user) {
        MFAUserProperty property = MFAUserProperty.forUser(user);
        return property != null && property.isEnabled();
    }

    public static boolean isMFARequired() {
        Optional<User> user = JenkinsUtil.getCurrentUser();
        if (user.isPresent()) {
            MFAUserProperty property = MFAUserProperty.forUser(user.get());
            return MFAGlobalConfiguration.get().isRequireMFA() || property != null && property.isEnabled();
        }
        return false;
    }

    public static boolean verifyCode(String secret, String code) {
        if (code == null || code.length() != 6) {
            return false;
        }
        try {
            long currentTimeCounter = System.currentTimeMillis() / 1000L / 30L;
            for (int i = -1; i <= 1; ++i) {
                String generatedCode = TOTPUtil.generateTOTP(secret, currentTimeCounter + (long)i);
                if (!generatedCode.equals(code)) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private static String generateTOTP(String key, String time, String returnDigits) {
        try {
            StringBuilder paddedTime = new StringBuilder();
            while (time.length() < 16) {
                paddedTime.append("0");
            }
            paddedTime.append(time);
            byte[] msg = TOTPUtil.hexStringToByteArray(paddedTime.toString());
            byte[] k = TOTPUtil.hexStringToByteArray(key);
            byte[] hash = TOTPUtil.hmacSha("HmacSHA1", k, msg);
            int offset = hash[hash.length - 1] & 0xF;
            int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
            int otp = binary % (int)Math.pow(10.0, Integer.parseInt(returnDigits));
            Object result = Integer.toString(otp);
            while (((String)result).length() < Integer.parseInt(returnDigits)) {
                result = "0" + (String)result;
            }
            return result;
        }
        catch (Exception e) {
            throw new MFAException("Error generating TOTP", e);
        }
    }

    private static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    private static byte[] hmacSha(String crypto, byte[] keyBytes, byte[] text) {
        try {
            Mac hmac = Mac.getInstance(crypto);
            SecretKeySpec macKey = new SecretKeySpec(keyBytes, "RAW");
            hmac.init(macKey);
            return hmac.doFinal(text);
        }
        catch (Exception e) {
            throw new MFAException("Error generating HMAC", e);
        }
    }

    @Generated
    private TOTPUtil() {
    }
}

