/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.openmfa.util;

import hudson.model.User;
import hudson.security.Permission;
import hudson.util.VersionNumber;
import java.util.Optional;
import jenkins.model.Jenkins;
import lombok.Generated;

public class JenkinsUtil {
    public static void checkAdminPermission() {
        JenkinsUtil.checkPermission(Jenkins.ADMINISTER);
    }

    public static void checkPermission(Permission permission) {
        if (!JenkinsUtil.isSecurityEnabled()) {
            return;
        }
        Jenkins.get().checkPermission(permission);
    }

    public static Optional<User> getCurrentUser() {
        return Optional.ofNullable(User.current());
    }

    public static Optional<Jenkins> getJenkins() {
        return Optional.ofNullable(Jenkins.getInstanceOrNull());
    }

    public static Optional<String> getJenkinsRootUrl() {
        return JenkinsUtil.getJenkins().map(Jenkins::getRootUrl);
    }

    public static Optional<VersionNumber> getJenkinsVersion() {
        return JenkinsUtil.getJenkins().map(j -> Jenkins.getVersion());
    }

    public static boolean hasPermission(Permission permission) {
        return !JenkinsUtil.isSecurityEnabled() || JenkinsUtil.getCurrentUser().map(u -> u.hasPermission(permission)).orElse(false) != false;
    }

    public static boolean isAdmin() {
        return JenkinsUtil.hasPermission(Jenkins.ADMINISTER);
    }

    public static boolean isSecurityEnabled() {
        return JenkinsUtil.getJenkins().map(Jenkins::isUseSecurity).orElse(false);
    }

    @Generated
    private JenkinsUtil() {
    }
}

