/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.openmfa.service;

import io.jenkins.plugins.openmfa.base.Service;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Logger;
import lombok.Generated;

@Service
public class SessionService {
    @Generated
    private static final Logger log = Logger.getLogger(SessionService.class.getName());

    public boolean isVerifiedSession(HttpSession session) {
        if (session == null) {
            return false;
        }
        Object attr = session.getAttribute("X-Plugin-OpenMFA-Verified");
        return Boolean.TRUE.equals(attr);
    }

    public void verifySession(HttpServletRequest request) {
        HttpSession session = this.regenerateSession(request);
        if (session != null) {
            session.setAttribute("X-Plugin-OpenMFA-Verified", (Object)true);
        }
    }

    private HttpSession regenerateSession(HttpServletRequest request) {
        HttpSession oldSession = request.getSession(false);
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        if (oldSession != null) {
            Enumeration names = oldSession.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                attrs.put(name, oldSession.getAttribute(name));
            }
            oldSession.invalidate();
        }
        HttpSession newSession = request.getSession(true);
        attrs.forEach((arg_0, arg_1) -> ((HttpSession)newSession).setAttribute(arg_0, arg_1));
        log.fine("Session regenerated for security");
        return newSession;
    }
}

