/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.openmfa.service;

import io.jenkins.plugins.openmfa.base.Service;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import lombok.Generated;

@Service
public class RateLimitService {
    @Generated
    private static final Logger log = Logger.getLogger(RateLimitService.class.getName());
    private final Map<String, CopyOnWriteArrayList<Long>> failedAttempts = new ConcurrentHashMap<String, CopyOnWriteArrayList<Long>>();
    private final Map<String, Long> lockouts = new ConcurrentHashMap<String, Long>();

    public void clearFailedAttempts(String username) {
        this.failedAttempts.remove(username);
        this.lockouts.remove(username);
        log.fine(String.format("Failed attempts cleared for user: %s", username));
    }

    public long getRemainingLockoutSeconds(String username) {
        Long lockoutExpiry = this.lockouts.get(username);
        if (lockoutExpiry == null) {
            return 0L;
        }
        long remaining = lockoutExpiry - System.currentTimeMillis();
        return remaining > 0L ? remaining / 1000L : 0L;
    }

    public boolean isLockedOut(String username) {
        Long lockoutExpiry = this.lockouts.get(username);
        if (lockoutExpiry == null) {
            return false;
        }
        if (System.currentTimeMillis() > lockoutExpiry) {
            this.lockouts.remove(username);
            this.failedAttempts.remove(username);
            log.fine(String.format("Lockout expired for user: %s", username));
            return false;
        }
        return true;
    }

    public void recordFailedAttempt(String username) {
        long now = System.currentTimeMillis();
        CopyOnWriteArrayList attempts = this.failedAttempts.computeIfAbsent(username, k -> new CopyOnWriteArrayList());
        this.cleanupExpiredAttempts(attempts, now);
        attempts.add(now);
        log.fine(String.format("Failed attempt recorded for user: %s, total attempts: %d", username, attempts.size()));
        if (attempts.size() >= 5) {
            this.lockouts.put(username, now + 300000L);
            log.warning(String.format("User %s locked out for %d seconds due to too many failed MFA attempts", username, 300L));
        }
    }

    private void cleanupExpiredAttempts(CopyOnWriteArrayList<Long> attempts, long now) {
        long cutoff = now - 300000L;
        attempts.removeIf(timestamp -> timestamp < cutoff);
    }
}

