/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.openmfa.base;

import io.jenkins.plugins.openmfa.base.Inject;
import io.jenkins.plugins.openmfa.base.MFAException;
import io.jenkins.plugins.openmfa.base.Service;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;

public class MFAContext {
    @Generated
    private static final Logger log = Logger.getLogger(MFAContext.class.getName());
    private static final String BASE_PACKAGE = "io.jenkins.plugins.openmfa";
    private static final MFAContext INSTANCE;
    private boolean initialized = false;
    private final Map<Class<?>, Object> services = new ConcurrentHashMap();

    public static MFAContext i() {
        return INSTANCE;
    }

    private MFAContext() {
    }

    public void clear() {
        this.services.clear();
        log.info("Cleared all services from MFAContext");
    }

    public <T> T getService(Class<T> serviceClass) {
        if (serviceClass == null) {
            throw new IllegalArgumentException("Service class cannot be null");
        }
        return (T)this.services.computeIfAbsent(serviceClass, clazz -> {
            try {
                if (!clazz.isAnnotationPresent(Service.class)) {
                    log.warning("Class " + clazz.getName() + " is not annotated with @Service");
                }
                Object instance = serviceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                log.info("Created and registered service: " + serviceClass.getName());
                return instance;
            }
            catch (Exception e) {
                throw new MFAException("Failed to instantiate service: " + serviceClass.getName(), e);
            }
        });
    }

    public int getServiceCount() {
        return this.services.size();
    }

    public boolean hasService(Class<?> serviceClass) {
        return this.services.containsKey(serviceClass);
    }

    public void initialize(String packageName) {
        if (this.initialized) {
            log.info("MFAContext already initialized");
            return;
        }
        try {
            log.info("Initializing MFAContext and scanning for services in package: " + packageName);
            List<Class<?>> serviceClasses = this.scanForServices(packageName);
            for (Class<?> serviceClass : serviceClasses) {
                if (this.hasService(serviceClass)) continue;
                Object instance = this.createServiceInstance(serviceClass);
                this.services.put(serviceClass, instance);
                log.info("Auto-registered service: " + serviceClass.getName());
            }
            this.injectDependencies();
            this.initialized = true;
            log.info("MFAContext init complete. Registered " + this.services.size() + " services.");
        }
        catch (Exception e) {
            throw new MFAException("Failed to initialize MFAContext", e);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public <T> void registerService(Class<T> serviceClass, T instance) {
        if (serviceClass == null || instance == null) {
            throw new IllegalArgumentException("Service class and instance cannot be null");
        }
        this.services.put(serviceClass, instance);
        this.injectIntoObject(instance);
        log.info("Registered service: " + serviceClass.getName());
    }

    public void removeService(Class<?> serviceClass) {
        Object removed = this.services.remove(serviceClass);
        if (removed != null) {
            log.info("Removed service: " + serviceClass.getName());
        }
    }

    private Object createServiceInstance(Class<?> serviceClass) {
        try {
            return serviceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new MFAException("Failed to instantiate service: " + serviceClass.getName(), e);
        }
    }

    private void injectDependencies() {
        for (Object service : this.services.values()) {
            this.injectIntoObject(service);
        }
    }

    private void injectIntoObject(Object target) {
        if (target == null) {
            return;
        }
        Class<?> clazz = target.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            try {
                field.setAccessible(true);
                Class<?> fieldType = field.getType();
                Object dependency = this.getService(fieldType);
                field.set(target, dependency);
                log.fine("Injected " + fieldType.getSimpleName() + " into " + clazz.getSimpleName() + "." + field.getName());
            }
            catch (Exception e) {
                throw new MFAException("Failed to inject dependency into field: " + field.getName(), e);
            }
        }
    }

    private void scanDirectory(File directory, String packageName, List<Class<?>> serviceClasses) {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.scanDirectory(file, packageName + "." + file.getName(), serviceClasses);
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String className = packageName + "." + file.getName().substring(0, file.getName().length() - 6);
            try {
                Class<?> clazz = Class.forName(className);
                if (!clazz.isAnnotationPresent(Service.class)) continue;
                serviceClasses.add(clazz);
            }
            catch (ClassNotFoundException e) {
                log.log(Level.SEVERE, "Could not load class: " + className, e);
            }
        }
    }

    private List<Class<?>> scanForServices(String packageName) {
        ArrayList serviceClasses = new ArrayList();
        try {
            String path = packageName.replace('.', '/');
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL resource = classLoader.getResource(path);
            if (resource == null) {
                log.warning("Package not found: " + packageName);
                return serviceClasses;
            }
            File directory = new File(resource.getFile());
            if (directory.exists()) {
                this.scanDirectory(directory, packageName, serviceClasses);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error scanning package: " + packageName, e);
        }
        return serviceClasses;
    }

    static {
        try {
            INSTANCE = new MFAContext();
            INSTANCE.initialize(BASE_PACKAGE);
        }
        catch (Exception e) {
            throw new MFAException("Exception while creating singleton instance", e);
        }
    }
}

