/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.openmfa;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.util.Secret;
import io.jenkins.plugins.openmfa.base.MFAContext;
import io.jenkins.plugins.openmfa.service.TOTPService;
import io.jenkins.plugins.openmfa.util.SecurityUtil;
import java.io.IOException;
import lombok.Generated;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.Stapler;

public class MFAUserProperty
extends UserProperty {
    @DataBoundSetter
    @CheckForNull
    private Secret secret;

    @CheckForNull
    public static MFAUserProperty forUser(@Nullable User user) {
        if (user == null) {
            return null;
        }
        return (MFAUserProperty)user.getProperty(MFAUserProperty.class);
    }

    @NonNull
    public static MFAUserProperty getOrCreate(User user) throws IOException {
        MFAUserProperty property = MFAUserProperty.forUser(user);
        if (property == null) {
            property = new MFAUserProperty();
            property.setUser(user);
            user.addProperty((UserProperty)property);
        }
        return property;
    }

    @DataBoundConstructor
    public MFAUserProperty() {
    }

    public MFAUserProperty(Secret secret) {
        this.secret = secret;
    }

    @NonNull
    public String getSetupActionUrl() {
        return SecurityUtil.buildSetupURI(Stapler.getCurrentRequest2().getContextPath(), this.getUser().getId());
    }

    public User getUser() {
        return this.user;
    }

    public boolean isEnabled() {
        return this.secret != null && !this.secret.getPlainText().isEmpty();
    }

    public boolean verifyCode(String code) {
        if (!this.isEnabled()) {
            return false;
        }
        return MFAContext.i().getService(TOTPService.class).verifyCode(this.secret, code);
    }

    @CheckForNull
    @Generated
    public Secret getSecret() {
        return this.secret;
    }

    @Generated
    public void setSecret(@CheckForNull Secret secret) {
        this.secret = secret;
    }
}

