/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.openmfa;

import hudson.Extension;
import hudson.model.InvisibleAction;
import hudson.model.RootAction;
import hudson.model.User;
import io.jenkins.plugins.openmfa.MFAUserProperty;
import io.jenkins.plugins.openmfa.base.MFAContext;
import io.jenkins.plugins.openmfa.service.RateLimitService;
import io.jenkins.plugins.openmfa.service.SessionService;
import io.jenkins.plugins.openmfa.util.JenkinsUtil;
import io.jenkins.plugins.openmfa.util.SecurityUtil;
import io.jenkins.plugins.openmfa.util.TOTPUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import lombok.Generated;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class MFALoginAction
extends InvisibleAction
implements RootAction {
    @Generated
    private static final Logger log = Logger.getLogger(MFALoginAction.class.getName());
    private final RateLimitService rateLimitService = MFAContext.i().getService(RateLimitService.class);
    private final SessionService sessionService = MFAContext.i().getService(SessionService.class);

    private static boolean isSafeRedirectTarget(String target) {
        if (target == null || target.isEmpty()) {
            return false;
        }
        if (!target.startsWith("/") || target.startsWith("//")) {
            return false;
        }
        String beforeQuery = target.split("\\?", 2)[0];
        return !beforeQuery.contains(":");
    }

    @RequirePOST
    public HttpResponse doVerify() {
        User user = User.current();
        if (user == null) {
            return HttpResponses.forbidden();
        }
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        String totpCode = req.getParameter("x-plugin-openmfa-totp");
        String fromParam = req.getParameter("from");
        MFAUserProperty mfaProperty = MFAUserProperty.forUser(user);
        if (mfaProperty == null) {
            log.warning(String.format("MFA property not found for user: %s", user.getId()));
            return HttpResponses.forbidden();
        }
        String username = mfaProperty.getUser().getId();
        if (this.rateLimitService.isLockedOut(username)) {
            long remainingSeconds = this.rateLimitService.getRemainingLockoutSeconds(username);
            log.warning(String.format("User %s is locked out, %d seconds remaining", username, remainingSeconds));
            String mfaLoginUrl = "/mfa-login?error=locked" + (String)(fromParam != null && !fromParam.isEmpty() ? "&from=" + URLEncoder.encode(fromParam, StandardCharsets.UTF_8) : "");
            return HttpResponses.redirectViaContextPath((String)mfaLoginUrl);
        }
        if (!mfaProperty.verifyCode(totpCode)) {
            this.rateLimitService.recordFailedAttempt(username);
            log.warning(String.format("Invalid MFA code for user: %s", username));
            String redirectUrl = "/mfa-login?error=" + (this.rateLimitService.isLockedOut(username) ? "locked" : "invalid") + (String)(fromParam != null && !fromParam.isEmpty() ? "&from=" + URLEncoder.encode(fromParam, StandardCharsets.UTF_8) : "");
            return HttpResponses.redirectViaContextPath((String)redirectUrl);
        }
        log.info(String.format("MFA verification successful for user: %s", username));
        this.rateLimitService.clearFailedAttempts(username);
        this.sessionService.verifySession((HttpServletRequest)req);
        String from = req.getParameter("from");
        if (from != null && !from.isEmpty() && MFALoginAction.isSafeRedirectTarget(from)) {
            return HttpResponses.redirectViaContextPath((String)from);
        }
        return HttpResponses.redirectViaContextPath((String)"/");
    }

    public String getFormParamTotpCode() {
        return "x-plugin-openmfa-totp";
    }

    public String getFromParam() {
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        if (req == null) {
            return null;
        }
        return req.getParameter("from");
    }

    public String getMFASetupPath() {
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        return JenkinsUtil.getCurrentUser().map(User::getId).map(userId -> SecurityUtil.buildSetupURI(req != null ? req.getContextPath() : "", userId)).orElse(null);
    }

    public String getPendingUsername() {
        return JenkinsUtil.getCurrentUser().map(User::getId).orElse(null);
    }

    public Long getRemainingLockoutSeconds() {
        User user = User.current();
        if (user == null) {
            return 0L;
        }
        return this.rateLimitService.getRemainingLockoutSeconds(user.getId());
    }

    public String getSafeFromParam() {
        String from = this.getFromParam();
        return from != null && MFALoginAction.isSafeRedirectTarget(from) ? from : null;
    }

    public String getSecurityCheckEndpoint() {
        return "/mfa-login/verify";
    }

    public String getUrlName() {
        return "mfa-login";
    }

    public boolean hasPendingAuth() {
        return this.getPendingUsername() != null;
    }

    public boolean isMFAEnabled() {
        return TOTPUtil.isMFAEnabled();
    }

    public boolean isMFARequired() {
        return TOTPUtil.isMFARequired();
    }

    public boolean isSessionMFAVerified() {
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        if (req == null) {
            return false;
        }
        HttpSession session = req.getSession(false);
        return session != null && MFAContext.i().getService(SessionService.class).isVerifiedSession(session);
    }

    public boolean shouldShowMFAOptionalNotice() {
        return JenkinsUtil.getCurrentUser().isPresent() && !this.isMFAEnabled() && !this.isMFARequired();
    }
}

