/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.github.api;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.TreeSet;
import jenkins.plugins.github.api.mock.MockGitHub;
import jenkins.plugins.github.api.mock.MockOrganization;
import jenkins.plugins.github.api.mock.MockUser;
import okhttp3.OkHttpClient;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.extras.okhttp3.OkHttpConnector;

@RunWith(value=Parameterized.class)
public class SmokeTest {
    @NonNull
    IOFunction connectFunction;

    public SmokeTest(IOFunction connectFunction) {
        this.connectFunction = connectFunction;
    }

    @Parameterized.Parameters(name="connectFunction={index}")
    public static IOFunction[] connectFunctions() {
        OkHttpConnector okHttp3Connector = new OkHttpConnector(new OkHttpClient());
        ArrayList<IOFunction> list = new ArrayList<IOFunction>();
        list.add(mock -> GitHub.connectToEnterpriseAnonymously((String)mock.open()));
        list.add(arg_0 -> SmokeTest.lambda$connectFunctions$1((HttpConnector)okHttp3Connector, arg_0));
        return list.toArray(new IOFunction[0]);
    }

    public GitHub openAndConnect(MockGitHub mock) throws IOException {
        return this.connectFunction.apply(mock);
    }

    @Test
    public void given__veryBasicMockGitHub__when__connectingAnonymously__then__apiUrlValid() throws Exception {
        try (MockGitHub mock = new MockGitHub();){
            this.openAndConnect(mock).checkApiUrlValidity();
        }
    }

    @Test
    public void given__veryBasicMockGitHub__when__listingRepos__then__reposListed() throws Exception {
        try (MockGitHub mock = new MockGitHub();){
            ((MockOrganization)mock.withOrg("org1").withPublicRepo("repo1")).withPrivateRepo("repo2");
            mock.withOrg("org2").withPublicRepo("repo3");
            ((MockUser)mock.withUser("user1").withPublicRepo("repo4")).withPrivateRepo("repo5");
            TreeSet<String> names = new TreeSet<String>();
            for (GHRepository r : this.openAndConnect(mock).listAllPublicRepositories()) {
                names.add(r.getFullName());
            }
            Assert.assertThat(names, (Matcher)Matchers.contains((Object[])new String[]{"org1/repo1", "org2/repo3", "user1/repo4"}));
        }
    }

    @Test
    public void given__veryBasicMockGitHub__when__listingManyRepos__then__reposListed() throws Exception {
        try (MockGitHub mock = new MockGitHub();){
            MockOrganization org1 = mock.withOrg("org1");
            TreeSet<CallSite> expected = new TreeSet<CallSite>();
            for (int i = 0; i < 95; ++i) {
                org1.withPublicRepo("repo" + i);
                expected.add((CallSite)((Object)("org1/repo" + i)));
            }
            TreeSet<String> actual = new TreeSet<String>();
            for (GHRepository r : this.openAndConnect(mock).listAllPublicRepositories()) {
                actual.add(r.getFullName());
            }
            Assert.assertThat(actual, (Matcher)Matchers.is(actual));
        }
    }

    @Test
    public void given__veryBasicMockGitHub__when__gettingUser__then__userReturned() throws Exception {
        try (MockGitHub mock = new MockGitHub();){
            MockUser expected = (MockUser)((MockUser)((MockUser)((MockUser)((MockUser)((MockUser)((MockUser)((MockUser)mock.withUser("user1").withAvatarUrl("http://avatar.test/user1")).withCompany("Testing Inc").withName("User One")).withBlog("https://user1.test")).withEmail("bob@test")).withLocation("Unit test")).withPrivateRepo("repo1")).withPublicRepo("repo2")).withPublicRepo("repo3");
            GHUser actual = this.openAndConnect(mock).getUser("user1");
            Assert.assertThat((Object)actual.getLogin(), (Matcher)Matchers.is((Object)expected.getLogin()));
            Assert.assertThat((Object)actual.getName(), (Matcher)Matchers.is((Object)expected.getName()));
            Assert.assertThat((Object)actual.getAvatarUrl(), (Matcher)Matchers.is((Object)expected.getAvatarUrl()));
            Assert.assertThat((Object)actual.getBlog(), (Matcher)Matchers.is((Object)expected.getBlog()));
            Assert.assertThat((Object)actual.getCompany(), (Matcher)Matchers.is((Object)expected.getCompany()));
            Assert.assertThat((Object)actual.getId(), (Matcher)Matchers.is((Object)expected.getId()));
            Assert.assertThat((Object)actual.getPublicRepoCount(), (Matcher)Matchers.is((Object)expected.getPublicRepos()));
        }
    }

    @Test
    public void given__veryBasicMockGitHub__when__gettingOrg__then__orgReturned() throws Exception {
        try (MockGitHub mock = new MockGitHub();){
            MockOrganization expected = (MockOrganization)((MockOrganization)((MockOrganization)((MockOrganization)((MockOrganization)((MockOrganization)((MockOrganization)mock.withOrg("org1").withAvatarUrl("http://avatar.test/org1")).withDescription("User One").withBlog("https://org1.test")).withEmail("bob@test")).withLocation("Unit test")).withPrivateRepo("repo1")).withPublicRepo("repo2")).withPublicRepo("repo3");
            GHOrganization actual = this.openAndConnect(mock).getOrganization("org1");
            Assert.assertThat((Object)actual.getLogin(), (Matcher)Matchers.is((Object)expected.getLogin()));
            Assert.assertThat((Object)actual.getName(), (Matcher)Matchers.is((Object)expected.getName()));
            Assert.assertThat((Object)actual.getAvatarUrl(), (Matcher)Matchers.is((Object)expected.getAvatarUrl()));
            Assert.assertThat((Object)actual.getBlog(), (Matcher)Matchers.is((Object)expected.getBlog()));
            Assert.assertThat((Object)actual.getId(), (Matcher)Matchers.is((Object)expected.getId()));
            Assert.assertThat((Object)actual.getPublicRepoCount(), (Matcher)Matchers.is((Object)expected.getPublicRepos()));
        }
    }

    private static /* synthetic */ GitHub lambda$connectFunctions$1(HttpConnector okHttp3Connector, MockGitHub mock) throws IOException {
        return new GitHubBuilder().withConnector(okHttp3Connector).withEndpoint(mock.open()).build();
    }

    @FunctionalInterface
    public static interface IOFunction {
        public GitHub apply(MockGitHub var1) throws IOException;
    }
}

