/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.oidc_provider;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.InvisibleAction;
import hudson.model.UnprotectedRootAction;
import hudson.security.ACL;
import hudson.security.ACLContext;
import io.jenkins.plugins.oidc_provider.IdTokenCredentials;
import io.jenkins.plugins.oidc_provider.Issuer;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import java.util.logging.Logger;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest2;
import org.springframework.security.core.Authentication;

@Extension
public final class Keys
extends InvisibleAction
implements UnprotectedRootAction {
    private static final Logger LOGGER = Logger.getLogger(Keys.class.getName());
    static final String URL_NAME = "oidc";
    static final String WELL_KNOWN_OPENID_CONFIGURATION = "/.well-known/openid-configuration";
    static final String JWKS = "/jwks";

    public String getUrlName() {
        return URL_NAME;
    }

    public JSONObject doDynamic(StaplerRequest2 req) {
        String path = req.getOriginalRestOfPath();
        try (ACLContext context = ACL.as2((Authentication)ACL.SYSTEM2);){
            Issuer i = Keys.findIssuer(path, WELL_KNOWN_OPENID_CONFIGURATION);
            if (i != null) {
                JSONObject jSONObject = Keys.openidConfiguration(i.url());
                return jSONObject;
            }
            i = Keys.findIssuer(path, JWKS);
            if (i != null) {
                JSONArray keys = new JSONArray();
                for (IdTokenCredentials idTokenCredentials : i.credentials()) {
                    if (idTokenCredentials.getIssuer() != null) {
                        LOGGER.fine(() -> "declining to serve key for " + creds.getId() + " since it would be served from " + creds.getIssuer());
                        continue;
                    }
                    keys.element(Keys.key(idTokenCredentials));
                }
                JSONObject jSONObject = new JSONObject().accumulate("keys", (Object)keys);
                return jSONObject;
            }
            throw HttpResponses.notFound();
        }
    }

    static JSONObject openidConfiguration(String issuer) {
        return new JSONObject().accumulate("issuer", (Object)issuer).accumulate("jwks_uri", (Object)(issuer + JWKS)).accumulate("response_types_supported", (Object)new JSONArray().element("code")).accumulate("subject_types_supported", (Object)new JSONArray().element("public")).accumulate("id_token_signing_alg_values_supported", (Object)new JSONArray().element("RS256")).accumulate("authorization_endpoint", (Object)"https://unimplemented").accumulate("token_endpoint", (Object)"https://unimplemented");
    }

    static JSONObject key(IdTokenCredentials creds) {
        RSAPublicKey key = creds.publicKey();
        Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
        return new JSONObject().accumulate("kid", (Object)creds.getId()).accumulate("kty", (Object)"RSA").accumulate("alg", (Object)"RS256").accumulate("use", (Object)"sig").accumulate("n", (Object)encoder.encodeToString(key.getModulus().toByteArray())).accumulate("e", (Object)encoder.encodeToString(key.getPublicExponent().toByteArray()));
    }

    @CheckForNull
    private static Issuer findIssuer(String path, String suffix) {
        if (path.endsWith(suffix)) {
            String uri = path.substring(0, path.length() - suffix.length());
            LOGGER.fine(() -> "looking up issuer for " + uri);
            for (Issuer.Factory f : ExtensionList.lookup(Issuer.Factory.class)) {
                Issuer i = f.forUri(uri);
                if (i == null) continue;
                if (!i.uri().equals(uri)) {
                    LOGGER.warning(() -> String.valueOf(i) + " was expected to have URI " + uri);
                    return null;
                }
                if (i.credentials().stream().noneMatch(c -> c.getIssuer() == null)) {
                    LOGGER.fine(() -> "found " + String.valueOf(i) + " but has no credentials with default issuer; not advertising existence of a folder");
                    return null;
                }
                LOGGER.fine(() -> "found " + String.valueOf(i));
                return i;
            }
        }
        return null;
    }
}

