/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.oidc_provider;

import com.cloudbees.plugins.credentials.CredentialsScope;
import hudson.Extension;
import hudson.util.Secret;
import io.jenkins.plugins.oidc_provider.IdTokenCredentials;
import java.security.KeyPair;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.DataBoundConstructor;

public final class IdTokenStringCredentials
extends IdTokenCredentials
implements StringCredentials {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public IdTokenStringCredentials(CredentialsScope scope, String id, String description) {
        super(scope, id, description);
    }

    private IdTokenStringCredentials(CredentialsScope scope, String id, String description, KeyPair kp, Secret privateKey) {
        super(scope, id, description, kp, privateKey);
    }

    public Secret getSecret() {
        return Secret.fromString((String)this.token());
    }

    @Override
    protected IdTokenCredentials clone(KeyPair kp, Secret privateKey) {
        return new IdTokenStringCredentials(this.getScope(), this.getId(), this.getDescription(), kp, privateKey);
    }

    @Symbol(value={"idToken"})
    @Extension
    public static class DescriptorImpl
    extends IdTokenCredentials.IdTokenCredentialsDescriptor {
        public String getDisplayName() {
            return "OpenID Connect id token";
        }
    }
}

