/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.oidc_backchannel_logout;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import hudson.security.SecurityRealm;
import io.jenkins.plugins.oidc_backchannel_logout.SessionTracker;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.oic.OicSecurityRealm;
import org.jenkinsci.plugins.oic.OicServerConfiguration;
import org.jenkinsci.plugins.oic.OicServerManualConfiguration;
import org.jenkinsci.plugins.oic.OicServerWellKnownConfiguration;
import org.kohsuke.accmod.restrictions.suppressions.SuppressRestrictedWarnings;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class OidcRootAction
implements UnprotectedRootAction {
    private static final Logger LOGGER = Logger.getLogger(OidcRootAction.class.getName());

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "oidc";
    }

    @RequirePOST
    @SuppressFBWarnings(value={"LSC_PERMISSION_CHECK"}, justification="Public endpoint for OIDC Backchannel Logout. Authenticity is validated via JWT signature verification.")
    public void doDynamic(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        String path = req.getRestOfPath();
        if ("/backchannel-logout".equals(path)) {
            this.doBackchannelLogout(req, rsp);
        } else {
            rsp.sendError(404);
        }
    }

    @RequirePOST
    private void doBackchannelLogout(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        LOGGER.fine("Received Backchannel Logout Request");
        String logoutToken = req.getParameter("logout_token");
        if (logoutToken == null) {
            rsp.setStatus(400);
            return;
        }
        try {
            SecurityRealm realm = Jenkins.get().getSecurityRealm();
            if (!(realm instanceof OicSecurityRealm)) {
                LOGGER.warning("OIDC Security Realm is not configured.");
                rsp.setStatus(500);
                return;
            }
            OicSecurityRealm oicRealm = (OicSecurityRealm)realm;
            String clientId = oicRealm.getClientId();
            String jwksUri = this.resolveJwksUri(oicRealm);
            if (jwksUri == null || clientId == null) {
                LOGGER.warning("Could not resolve JWKS URI or Client ID.");
                rsp.setStatus(500);
                return;
            }
            DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
            jwtProcessor.setJWSTypeVerifier((JOSEObjectTypeVerifier)new DefaultJOSEObjectTypeVerifier(new JOSEObjectType[]{new JOSEObjectType("logout+jwt")}));
            RemoteJWKSet keySource = new RemoteJWKSet(new URL(jwksUri));
            JWSAlgorithm expectedJWSAlg = JWSAlgorithm.RS256;
            JWSVerificationKeySelector keySelector = new JWSVerificationKeySelector(expectedJWSAlg, (JWKSource)keySource);
            jwtProcessor.setJWSKeySelector((JWSKeySelector)keySelector);
            JWTClaimsSet claims = jwtProcessor.process(logoutToken, null);
            if (!claims.getAudience().contains(clientId)) {
                LOGGER.warning("Token verification failed: Audience mismatch.");
                rsp.setStatus(400);
                return;
            }
            String sid = (String)claims.getClaim("sid");
            if (sid != null) {
                SessionTracker.invalidate(sid);
                rsp.setStatus(200);
            } else {
                LOGGER.warning("Token verification passed, but SID claim is missing.");
                rsp.setStatus(400);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Backchannel verification failed: {0}", e.getMessage());
            rsp.setStatus(400);
        }
    }

    @SuppressRestrictedWarnings(value={OicSecurityRealm.class})
    private String resolveJwksUri(OicSecurityRealm oicRealm) {
        try {
            OicServerConfiguration serverConfig = oicRealm.getServerConfiguration();
            if (serverConfig == null) {
                return null;
            }
            if (serverConfig instanceof OicServerManualConfiguration) {
                return ((OicServerManualConfiguration)serverConfig).getJwksServerUrl();
            }
            if (serverConfig instanceof OicServerWellKnownConfiguration) {
                String wellKnownUrl = ((OicServerWellKnownConfiguration)serverConfig).getWellKnownOpenIDConfigurationUrl();
                return this.fetchJwksFromWellKnown(wellKnownUrl);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error resolving JWKS URI: {0}", e.getMessage());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String fetchJwksFromWellKnown(String wellKnownUrl) {
        if (wellKnownUrl == null) return null;
        if (wellKnownUrl.isEmpty()) return null;
        try (InputStream is = new URL(wellKnownUrl).openStream();){
            String jsonMetadata = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            JSONObject json = JSONObject.fromObject((Object)jsonMetadata);
            if (!json.containsKey((Object)"jwks_uri")) return null;
            String string = json.getString("jwks_uri");
            return string;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to fetch/parse Well-Known configuration: {0}", e.getMessage());
        }
        return null;
    }
}

