/*
 * Decompiled with CFR 0.152.
 */
package org.miniorange.saml.crowdIntegration;

import hudson.model.User;
import hudson.util.Secret;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.miniorange.saml.MoHttpUtils;
import org.miniorange.saml.MoSAMLPluginSettings;

public class MoSAMLCrowdGroupManagement {
    private static final Logger LOGGER = Logger.getLogger(MoSAMLCrowdGroupManagement.class.getName());
    String CROWD_USER_GROUP_FETCH_URL = "/rest/usermanagement/1/user/group/direct?username=";

    private String fetchGroupDataFromCrowd(String username, MoSAMLPluginSettings settings) {
        try {
            String applicationName = settings.getCrowdApplicationName();
            Secret password = settings.getCrowdApplicationPassword();
            String url = settings.getCrowdURL() + this.CROWD_USER_GROUP_FETCH_URL + username;
            LOGGER.info("Get request to fetch groups from crowd " + url);
            String response = MoHttpUtils.sendGetRequest(url, MoSAMLCrowdGroupManagement.getAuthorizationHeaders(applicationName, password.getPlainText()));
            return response;
        }
        catch (IOException e) {
            LOGGER.fine("An exception occurred while sending get request: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public ArrayList<String> directGroupsFromCrowd(MoSAMLPluginSettings settings, User user) {
        String username = user.getId();
        LOGGER.info("username is : " + username);
        String recievedResponse = this.fetchGroupDataFromCrowd(username, settings);
        LOGGER.fine("recievedResponse from fetchGroupDataFromCrowd : " + recievedResponse);
        return this.parseResponseAndGetAttribute(recievedResponse);
    }

    private ArrayList<String> parseResponseAndGetAttribute(String recievedResponse) {
        ArrayList<String> groupListFromCrowd = new ArrayList<String>();
        if (!StringUtils.isBlank((String)recievedResponse) && !recievedResponse.equals("Empty")) {
            JSONObject userInfo = new JSONObject(recievedResponse);
            JSONArray groupArray = userInfo.optJSONArray("groups");
            for (int i = 0; i < groupArray.length(); ++i) {
                JSONObject subgroupJSONObject = groupArray.optJSONObject(i);
                String groupName = subgroupJSONObject.optString("name");
                groupListFromCrowd.add(groupName);
            }
        } else if (recievedResponse.equals("Empty")) {
            groupListFromCrowd.add("Empty");
        }
        return groupListFromCrowd;
    }

    private static HashMap<String, String> getAuthorizationHeaders(String applicationName, String password) {
        LOGGER.fine("in getAuthorizationHeaders ");
        HashMap<String, String> headers = new HashMap<String, String>();
        String auth = applicationName + ":" + password;
        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.UTF_8));
        String authHeader = "Basic " + new String(encodedAuth, StandardCharsets.UTF_8);
        headers.put("Authorization", authHeader);
        headers.put("Accept", "application/json");
        LOGGER.fine("Headers" + headers);
        return headers;
    }
}

